#ifndef _SRTACTIVESURFACEBOSSSECTORTHREAD_H_
#define _SRTACTIVESURFACEBOSSSECTORTHREAD_H_

/* ********************************************************************************* */
/* OAC Osservatorio Astronomico di Cagliari                                          */
/* $Id: SRTActiveSurfaceBossSector1Thread.h,v 1.1 2010-07-26 12:36:49 c.migoni Exp $ */
/*                                                                                   */
/* This code is under GNU General Public Licence (GPL).                              */
/*                                                                                   */
/* Who                                          when        What                     */
/* Giuseppe Carboni (giuseppe.carboni@inaf.it)  02/07/2019  Creation                 */

#include <acsThread.h>
#include <IRA>
#include "SRTActiveSurfaceBossCore.h"
#include <ComponentErrors.h>

/**
 * This class implements a Sector thread. This thread is in charge of updating the active surface
*/
class CSRTActiveSurfaceBossSectorThread : public ACS::Thread
{
public:
    /**
     * Constructor().
     * @param name thread name
     * @param responseTime thread's heartbeat response time in 100ns unit. Default value is 1s.
     * @param sleepTime thread's sleep time in 100ns unit. Default value is 100ms.
    */
    CSRTActiveSurfaceBossSectorThread(const ACE_CString& name, CSRTActiveSurfaceBossCore *param,
            const ACS::TimeInterval& responseTime=ThreadBase::defaultResponseTime,const ACS::TimeInterval& sleepTime=ThreadBase::defaultSleepTime);

    /**
     * Destructor.
    */
    ~CSRTActiveSurfaceBossSectorThread();

     /**
     * This method is executed once when the thread starts.
    */
    virtual void onStart();

    /**
     * This method is executed once when the thread stops.
     */
     virtual void onStop();

     /**
      * This method overrides the thread implementation class.
      * The thread can be exited by calling ACS::ThreadBase::stop or ACS::ThreadBase::exit command.
     */
     virtual void runLoop();

     /**
      * This method is used to set the sector to be initialized. It MUST be called before starting the thread execution
     */
     virtual void prepare(int sector);

private:

    IRA::CSecureArea<CSRTActiveSurfaceBossCore> *m_core;
    CSRTActiveSurfaceBossCore *boss;
    int m_sector, m_index, m_usd_count;
    bool m_ready;
    std::vector<int> m_lanIndexes, m_circleIndexes, m_usdCircleIndexes;
    std::vector<std::string> m_serial_usds;
};

#endif /*_SRTACTIVESURFACEBOSSSECTORTHREAD_H_*/
