/*
 ************************************************************************
 *******************  CANADIAN ASTRONOMY DATA CENTRE  *******************
 **************  CENTRE CANADIEN DE DONNÉES ASTRONOMIQUES  **************
 *
 *  (c) 2014.                            (c) 2014.
 *  Government of Canada                 Gouvernement du Canada
 *  National Research Council            Conseil national de recherches
 *  Ottawa, Canada, K1A 0R6              Ottawa, Canada, K1A 0R6
 *  All rights reserved                  Tous droits réservés
 *
 *  NRC disclaims any warranties,        Le CNRC dénie toute garantie
 *  expressed, implied, or               énoncée, implicite ou légale,
 *  statutory, of any kind with          de quelque nature que ce
 *  respect to the software,             soit, concernant le logiciel,
 *  including without limitation         y compris sans restriction
 *  any warranty of merchantability      toute garantie de valeur
 *  or fitness for a particular          marchande ou de pertinence
 *  purpose. NRC shall not be            pour un usage particulier.
 *  liable in any event for any          Le CNRC ne pourra en aucun cas
 *  damages, whether direct or           être tenu responsable de tout
 *  indirect, special or general,        dommage, direct ou indirect,
 *  consequential or incidental,         particulier ou général,
 *  arising from the use of the          accessoire ou fortuit, résultant
 *  software.  Neither the name          de l'utilisation du logiciel. Ni
 *  of the National Research             le nom du Conseil National de
 *  Council of Canada nor the            Recherches du Canada ni les noms
 *  names of its contributors may        de ses  participants ne peuvent
 *  be used to endorse or promote        être utilisés pour approuver ou
 *  products derived from this           promouvoir les produits dérivés
 *  software without specific prior      de ce logiciel sans autorisation
 *  written permission.                  préalable et particulière
 *                                       par écrit.
 *
 *  This file is part of the             Ce fichier fait partie du projet
 *  OpenCADC project.                    OpenCADC.
 *
 *  OpenCADC is free software:           OpenCADC est un logiciel libre ;
 *  you can redistribute it and/or       vous pouvez le redistribuer ou le
 *  modify it under the terms of         modifier suivant les termes de
 *  the GNU Affero General Public        la “GNU Affero General Public
 *  License as published by the          License” telle que publiée
 *  Free Software Foundation,            par la Free Software Foundation
 *  either version 3 of the              : soit la version 3 de cette
 *  License, or (at your option)         licence, soit (à votre gré)
 *  any later version.                   toute version ultérieure.
 *
 *  OpenCADC is distributed in the       OpenCADC est distribué
 *  hope that it will be useful,         dans l’espoir qu’il vous
 *  but WITHOUT ANY WARRANTY;            sera utile, mais SANS AUCUNE
 *  without even the implied             GARANTIE : sans même la garantie
 *  warranty of MERCHANTABILITY          implicite de COMMERCIALISABILITÉ
 *  or FITNESS FOR A PARTICULAR          ni d’ADÉQUATION À UN OBJECTIF
 *  PURPOSE.  See the GNU Affero         PARTICULIER. Consultez la Licence
 *  General Public License for           Générale Publique GNU Affero
 *  more details.                        pour plus de détails.
 *
 *  You should have received             Vous devriez avoir reçu une
 *  a copy of the GNU Affero             copie de la Licence Générale
 *  General Public License along         Publique GNU Affero avec
 *  with OpenCADC.  If not, see          OpenCADC ; si ce n’est
 *  <http://www.gnu.org/licenses/>.      pas le cas, consultez :
 *                                       <http://www.gnu.org/licenses/>.
 *
 *  $Revision: 4 $
 *
 ************************************************************************
 */
package ca.nrc.cadc.ac.json;

import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.UserDetails;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Principal;
import java.util.Scanner;

public class UserReader
{
    /**
     * Construct a User from a InputStream.
     *
     * @param in InputStream.
     * @return User User.
     * @throws ReaderException
     * @throws IOException
     */
    public static User<Principal> read(InputStream in)
        throws IOException
    {
        if (in == null)
        {
            throw new IOException("stream closed");
        }

        Scanner s = new Scanner(in).useDelimiter("\\A");
        String json = s.hasNext() ? s.next() : "";

        return read(json);
    }

    /**
     * Construct a User from a Reader.
     *
     * @param reader Reader.
     * @return User User.
     * @throws ReaderException
     * @throws IOException
     */
    public static User<Principal> read(Reader reader)
        throws IOException
    {
        if (reader == null)
        {
            throw new IllegalArgumentException("reader must not be null");
        }

        Scanner s = new Scanner(reader).useDelimiter("\\A");
        String json = s.hasNext() ? s.next() : "";

        return read(json);
    }

    /**
     * Construct a User from an JSON String source.
     *
     * @param json String of JSON.
     * @return User User.
     * @throws ReaderException
     * @throws IOException
     */
    public static User<Principal> read(String json)
        throws IOException
    {
        if (json == null || json.isEmpty())
        {
            throw new IllegalArgumentException("JSON must not be null or empty");
        }

        // Create a JSONObject from the JSON
        try
        {
            return parseUser(new JSONObject(json).getJSONObject("user"));
        }
        catch (JSONException e)
        {
            String error = "Unable to parse JSON to User because " +
                           e.getMessage();
            throw new ReaderException(error, e);
        }
    }

    protected static User<Principal> parseUser(JSONObject userObject)
        throws ReaderException, JSONException
    {
        JSONObject userIDObject = userObject.getJSONObject("userID");
        JSONObject userIDIdentityObject = userIDObject.getJSONObject("identity");

        Principal userID = IdentityReader.read(userIDIdentityObject);
        User<Principal> user = new User<Principal>(userID);

        // identities
        if (userObject.has("identities"))
        {
            JSONArray identitiesArray = userObject.getJSONArray("identities");
            for (int i = 0; i < identitiesArray.length(); i++)
            {
                JSONObject identitiesObject = identitiesArray.getJSONObject(i);
                JSONObject identityObject = identitiesObject.getJSONObject(("identity"));
                user.getIdentities().add(IdentityReader.read(identityObject));
            }
        }

        // details
        if (userObject.has("details"))
        {
            JSONArray detailsArray = userObject.getJSONArray("details");
            for (int i = 0; i < detailsArray.length(); i++)
            {
                JSONObject detailsObject = detailsArray.getJSONObject(i);
                JSONObject userDetailsObject = detailsObject.getJSONObject(UserDetails.NAME);
                user.details.add(UserDetailsReader.read(userDetailsObject));
            }
        }

        return user;
    }

}
