/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Band {
    public System system;
    public double[] wavelength;

    public static Band parseBand(Map<String, String[]> params) {
        Parser parser = new Parser(params);
        return parser.getBand();
    }

    public Band(String str) {
        this.wavelength = Interval.getDaliIntervalPositiveValues(str, "BAND");
    }

    public Band(double low, double up) {
        this.wavelength = new double[2];
        this.wavelength[0] = low;
        this.wavelength[1] = up;
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String toString() {
        return "BAND " + this.wavelength[0] + " " + this.wavelength[1];
    }

    public static enum System {
        WAVE_Barycentric,
        VELO_LSRK,
        NONE;

    }
}

