/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import vo.parameter.Band;
import vo.parameter.Circle;
import vo.parameter.Interval;
import vo.parameter.MultiValuedParamNotSupported;
import vo.parameter.Pol;
import vo.parameter.Polygon;
import vo.parameter.Pos;
import vo.parameter.Range;
import vo.parameter.Time;

class Parser {
    protected static final Logger LOGGER = Logger.getLogger("Parser");
    private Map<String, String[]> params;

    public Parser(Map<String, String[]> params) {
        LOGGER.info("trace - there are " + params.size() + " params");
        this.params = params;
    }

    private String soda_getSingleValue(VoParam name) {
        LOGGER.info("trace : " + name);
        return this.getSingleValue(name.toString());
    }

    public String getSingleValue(String name) {
        return this.getSingleValue(name, null);
    }

    public String getSingleValue(String name, String defaultValue) {
        String[] valArr = this.params.get(name);
        if (valArr == null) {
            return defaultValue;
        }
        if (valArr.length == 0) {
            return defaultValue;
        }
        if (valArr.length == 1) {
            LOGGER.info("ParamFound " + name.toString() + " : " + valArr[0]);
            return valArr[0];
        }
        throw new MultiValuedParamNotSupported(name + " was found " + valArr.length + " times");
    }

    private Interval siav2Req_getInterval(VoParam intervalParam) {
        String value = this.soda_getSingleValue(intervalParam);
        if (value == null) {
            return null;
        }
        return new Interval(value);
    }

    public Interval siav2Req_getFov() {
        return this.siav2Req_getInterval(VoParam.FOV);
    }

    public Interval siav2Req_getSpatres() {
        return this.siav2Req_getInterval(VoParam.SPATRES);
    }

    public Interval siav2Req_getSpecrp() {
        return this.siav2Req_getInterval(VoParam.SPECRP);
    }

    public Interval siav2Req_getExptime() {
        return this.siav2Req_getInterval(VoParam.EXPTIME);
    }

    public Interval siav2Req_getTimeres() {
        return this.siav2Req_getInterval(VoParam.TIMERES);
    }

    public boolean hasSodaId() {
        String id = this.soda_getSingleValue(VoParam.ID);
        return id != null;
    }

    public String getId() {
        String pubdid = this.soda_getSingleValue(VoParam.ID);
        if (pubdid == null) {
            throw new IllegalArgumentException("ID is missing, but is mandatory");
        }
        return pubdid;
    }

    public Pos getPosCirclePolygon() {
        String valuePos = this.soda_getSingleValue(VoParam.POS);
        String valueCircle = this.soda_getSingleValue(VoParam.CIRCLE);
        String valuePolygon = this.soda_getSingleValue(VoParam.POLYGON);
        Pos pos = null;
        if (valuePos != null && valueCircle == null && valuePolygon == null) {
            pos = new Pos(valuePos);
            LOGGER.info(pos.toString());
        } else if (valuePos == null && valueCircle != null && valuePolygon == null) {
            Circle circle = new Circle(valueCircle);
            LOGGER.info(circle.toString());
            pos = new Pos(circle);
        } else if (valuePos == null && valueCircle == null && valuePolygon != null) {
            Polygon polygon = new Polygon(valuePolygon);
            LOGGER.info(polygon.toString());
            pos = new Pos(polygon);
        } else {
            throw new IllegalArgumentException("Exactly one of POS | CIRCLE | POLYGON must be given.");
        }
        return pos;
    }

    public Circle getCircle() {
        String value = this.soda_getSingleValue(VoParam.CIRCLE);
        if (value == null) {
            return null;
        }
        return new Circle(value);
    }

    public Range getRange() {
        String value = this.soda_getSingleValue(VoParam.RANGE);
        if (value == null) {
            return null;
        }
        return new Range(value);
    }

    public Polygon getPolygon() {
        String value = this.soda_getSingleValue(VoParam.POLYGON);
        if (value == null) {
            return null;
        }
        return new Polygon(value);
    }

    public Band getBand() {
        String value = this.soda_getSingleValue(VoParam.BAND);
        if (value == null) {
            return null;
        }
        return new Band(value);
    }

    public Time getTime() {
        String value = this.soda_getSingleValue(VoParam.TIME);
        if (value == null) {
            return null;
        }
        return new Time(value);
    }

    public Pol getPol() {
        Object[] valArr = this.params.get((Object)VoParam.POL);
        if (valArr == null) {
            return null;
        }
        if (valArr.length < 1) {
            return null;
        }
        LOGGER.info("ParamFound " + VoParam.POL.toString() + " : " + Arrays.toString(valArr));
        return new Pol((String[])valArr);
    }

    public String vlkbReq_getPubdid() {
        String pubdid = this.soda_getSingleValue(VoParam.pubdid);
        if (pubdid == null) {
            throw new IllegalArgumentException(VoParam.pubdid.toString() + " is missing, but is mandatory");
        }
        return pubdid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pos vlkbReq_getCircleRect() {
        Pos pos = null;
        String l_value = this.soda_getSingleValue(VoParam.l);
        String b_value = this.soda_getSingleValue(VoParam.b);
        if (l_value == null) throw new IllegalArgumentException("VLKB sky position center (l,b) is missing however is mandatory");
        if (b_value == null) throw new IllegalArgumentException("VLKB sky position center (l,b) is missing however is mandatory");
        String r_value = this.soda_getSingleValue(VoParam.r);
        if (r_value != null) {
            Circle circle = new Circle(l_value + " " + b_value + " " + r_value);
            return new Pos(circle);
        }
        String dl_value = this.soda_getSingleValue(VoParam.dl);
        String db_value = this.soda_getSingleValue(VoParam.db);
        if (dl_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
        if (db_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
        double l = Double.parseDouble(l_value);
        double b = Double.parseDouble(b_value);
        double dl = Double.parseDouble(dl_value);
        double db = Double.parseDouble(db_value);
        Range range = new Range(l, b, dl, db);
        return new Pos(range);
    }

    public Band vlkbReq_getVelocity() {
        boolean vel_valid;
        Band band = null;
        String cvlow = this.soda_getSingleValue(VoParam.vl);
        String cvup = this.soda_getSingleValue(VoParam.vu);
        boolean bl = vel_valid = cvlow != null && cvup != null;
        if (vel_valid) {
            double vel_low = Double.parseDouble(cvlow);
            double vel_up = Double.parseDouble(cvup);
            band = new Band(vel_low, vel_up);
        }
        return band;
    }

    public boolean vlkbReq_getNullValues() {
        return null != this.soda_getSingleValue(VoParam.nullvals);
    }

    private static enum VoParam {
        ID,
        POS,
        CIRCLE,
        RANGE,
        POLYGON,
        BAND,
        TIME,
        POL,
        skysystem,
        specsystem,
        pubdid,
        l,
        b,
        r,
        dl,
        db,
        vtype,
        vl,
        vu,
        nullvals,
        FOV,
        SPATRES,
        SPECRP,
        EXPTIME,
        TIMERES,
        POSSYS,
        BANDSYS,
        TIMESYS;

    }
}

