/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.logging.Logger;
import nom.tam.fits.AbstractTableData;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.header.GenericKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;

public abstract class TableHDU<T extends AbstractTableData>
extends BasicHDU<T> {
    private static final Logger LOG = Logger.getLogger(TableHDU.class.getName());

    protected TableHDU(Header hdr, T td) {
        super(hdr, td);
    }

    public int addColumn(Object newCol) throws FitsException {
        int nCols = this.getNCols();
        this.myHeader.addValue((IFitsHeader)Standard.TFIELDS, nCols);
        return nCols;
    }

    public int addRow(Object[] newRow) throws FitsException {
        int row = ((AbstractTableData)this.myData).addRow(newRow);
        this.myHeader.addValue(Standard.NAXISn.n(2), this.getNRows());
        return row;
    }

    protected abstract IFitsHeader[] columnKeyStems();

    public void deleteColumnsIndexOne(int column, int len) throws FitsException {
        this.deleteColumnsIndexZero(column - 1, len);
    }

    public void deleteColumnsIndexOne(int column, int len, String[] fields) throws FitsException {
        this.deleteColumnsIndexZero(column - 1, len, GenericKey.create(fields));
    }

    public void deleteColumnsIndexZero(int column, int len) throws FitsException {
        this.deleteColumnsIndexZero(column, len, this.columnKeyStems());
    }

    public void deleteColumnsIndexZero(int column, int len, IFitsHeader[] fields) throws FitsException {
        int col;
        if (column < 0 || len < 0 || column + len > this.getNCols()) {
            throw new FitsException("Illegal columns deletion request- Start:" + column + " Len:" + len + " from table with " + this.getNCols() + " columns");
        }
        if (len == 0) {
            return;
        }
        int ncol = this.getNCols();
        ((AbstractTableData)this.myData).deleteColumns(column, len);
        for (col = column; col < column + len; ++col) {
            for (IFitsHeader field : fields) {
                this.myHeader.deleteKey(field.n(col + 1));
            }
        }
        for (col = column + len; col < ncol; ++col) {
            for (IFitsHeader field : fields) {
                IFitsHeader oldKey = field.n(col + 1);
                IFitsHeader newKey = field.n(col + 1 - len);
                if (!this.myHeader.containsKey(oldKey)) continue;
                this.myHeader.replaceKey(oldKey, newKey);
            }
        }
        this.myHeader.addValue((IFitsHeader)Standard.TFIELDS, this.getNCols());
        ((AbstractTableData)this.myData).updateAfterDelete(ncol, this.myHeader);
    }

    public void deleteRows(int row) throws FitsException {
        this.deleteRows(row, this.getNRows() - row);
    }

    public void deleteRows(int firstRow, int nRow) throws FitsException {
        if (nRow <= 0 || firstRow >= this.getNRows() || firstRow <= 0) {
            return;
        }
        if (nRow > this.getNRows() - firstRow) {
            nRow = this.getNRows() - firstRow;
        }
        ((AbstractTableData)this.myData).deleteRows(firstRow, nRow);
        this.myHeader.setNaxis(2, this.getNRows());
    }

    public int findColumn(String colName) {
        for (int i = 0; i < this.getNCols(); ++i) {
            String val = this.myHeader.getStringValue(Standard.TTYPEn.n(i + 1));
            if (val == null || !val.trim().equals(colName)) continue;
            return i;
        }
        return -1;
    }

    public Object getColumn(int col) throws FitsException {
        return ((AbstractTableData)this.myData).getColumn(col);
    }

    public Object getColumn(String colName) throws FitsException {
        return this.getColumn(this.findColumn(colName));
    }

    public String getColumnFormat(int index) throws FitsException {
        int flds = this.myHeader.getIntValue(Standard.TFIELDS, 0);
        if (index < 0 || index >= flds) {
            throw new FitsException("Bad column index " + index + " (only " + flds + " columns)");
        }
        return this.myHeader.getStringValue(Standard.TFORMn.n(index + 1)).trim();
    }

    public String getColumnMeta(int index, String type) {
        return this.myHeader.getStringValue(type + (index + 1));
    }

    public String getColumnName(int index) {
        String ttype = this.myHeader.getStringValue(Standard.TTYPEn.n(index + 1));
        if (ttype != null) {
            ttype = ttype.trim();
        }
        return ttype;
    }

    public Object[] getColumns() throws FitsException {
        Object[] result = new Object[this.getNCols()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getColumn(i);
        }
        return result;
    }

    public Object getElement(int row, int col) throws FitsException {
        return ((AbstractTableData)this.myData).getElement(row, col);
    }

    public int getNCols() {
        return ((AbstractTableData)this.myData).getNCols();
    }

    public int getNRows() {
        return ((AbstractTableData)this.myData).getNRows();
    }

    public Object[] getRow(int row) throws FitsException {
        return ((AbstractTableData)this.myData).getRow(row);
    }

    public void setColumn(int col, Object newCol) throws FitsException {
        ((AbstractTableData)this.myData).setColumn(col, newCol);
    }

    public void setColumn(String colName, Object newCol) throws FitsException {
        this.setColumn(this.findColumn(colName), newCol);
    }

    public void setColumnMeta(int index, IFitsHeader key, String value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(key.n(index + 1).key(), value, comment);
    }

    public void setColumnMeta(int index, String key, boolean value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(key + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, double value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(key + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, long value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(key + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, String value, String comment) throws FitsException {
        this.setColumnMeta(index, key, value, comment, true);
    }

    @Deprecated
    public void setColumnMeta(int index, String key, String value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(key + (index + 1), value, comment);
    }

    public void setColumnName(int index, String name, String comment) throws FitsException {
        this.setColumnMeta(index, Standard.TTYPEn, name, comment, true);
    }

    public void setCurrentColumn(int col) {
        this.setCurrentColumn(col, true);
    }

    public void setCurrentColumn(int col, boolean after) {
        if (after) {
            this.myHeader.positionAfterIndex(Standard.TFORMn, col + 1);
        } else {
            this.myHeader.findCard(Standard.TFORMn.n(col + 1));
        }
    }

    public void setElement(int row, int col, Object element) throws FitsException {
        ((AbstractTableData)this.myData).setElement(row, col, element);
    }

    public void setRow(int row, Object[] newRow) throws FitsException {
        ((AbstractTableData)this.myData).setRow(row, newRow);
    }
}

