## vlkb-siav2

is a web-application to discover astronomical data stored in FITS-files and described in a VO ObsCore table.
It implements the SIA version 2, IVOA recommendation (https://ivoa.net/documents/SIA/20151223/) with optional VLKB-specific features:

- provides overlap code
- the filtering paramters (POS, BAND) can be given in GALACTIC and VELO-LSRK-km/s coordinates systems
- handles addtional metadata about the surveys (name, species, transformation)
- VOTable response includes composed URLs for file download, file-cutout and files-demosaic services

The service consists of **vlkb-siav2** web-application and associated **vlkb-obscore** command line tool to create the VO ObsCore table from FITS-files.

The vlkb-obscore cli is available from https://ict.inaf.it/gitlab/butora/vlkb-datasets .
Dockerized version of the web-app is available from https://ict.inaf.it/gitlab/butora/vlkb-datasets-docker .

## Installation

There is a war-package for the search web-application and the package (deb or rpm) with linux
executable for Debian, CentOS and Fedora:

- vlkb-search-X.Y.Z.war
- vlkb-obscore-X.Y.Z.deb|.rpm

To download version X.Y, add one of the above package names to

```bash
curl -O --header "PRIVATE-TOKEN: <security-token>"  "https://ict.inaf.it/gitlab/api/v4/projects/79/packages/generic/vlkb-datasets/X.Y/vlkb-obscore-<version>.{deb|rpm}"

```


