

import java.lang.StringBuilder;


class Inputs
{
   Coord coord;
   SubsurveyId subsurveyId;
   boolean countNullValues;
   AuthPolicy auth;

   String queryString;

   public Inputs(AuthPolicy auth, Coord coord, SubsurveyId subsurveyId, boolean countNullValues)
   {
      this.coord = coord;
      this.subsurveyId = subsurveyId;
      this.countNullValues = countNullValues;
      this.auth = auth;

      queryString = buildVoQueryString(coord, subsurveyId, countNullValues);
      //queryString = buildQueryString(coord, subsurveyId, countNullValues);
   }


   private String buildQueryString(Coord coord, SubsurveyId subsurveyId, boolean countNullValues)
   {
      StringBuilder queryString = new StringBuilder();

      queryString.append(coord.toQueryString());
      if(subsurveyId.surveyName != null) queryString.append("&amp;surveyname=" + subsurveyId.surveyName);
      if(subsurveyId.species != null) queryString.append("&amp;species=" + subsurveyId.species);
      if(subsurveyId.transition != null) queryString.append("&amp;transition=" + subsurveyId.transition);

      return queryString.toString();
   }

   private String buildVoQueryString(Coord coord, SubsurveyId subsurveyId, boolean countNullValues)
   {
      StringBuilder queryString = new StringBuilder();

      queryString.append(coord.toVoQueryString());
      if(subsurveyId.surveyName != null) queryString.append("&surveyname=" + subsurveyId.surveyName);
      if(subsurveyId.species != null) queryString.append("&species=" + subsurveyId.species);
      if(subsurveyId.transition != null) queryString.append("&transition=" + subsurveyId.transition);

      return queryString.toString();
   }

}

