
import java.util.logging.Logger;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import java.security.Principal;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class SearchServlet extends javax.servlet.http.HttpServlet
{
   private static final Logger         LOGGER   = Logger.getLogger("PSearch");
   private static final SearchSettings settings = SearchSettings.getInstance("discovery.properties");


   public void init() throws ServletException
   {
      super.init();

      LOGGER.info("URLs : " + settings.serviceUrls.toString());
      LOGGER.info("DB   : " + settings.dbConn.toString());
   }


   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException, UnsupportedEncodingException
   {
      LOGGER.info("trace");

      long startTime_msec = System.currentTimeMillis();

      legacyLogEntry(request);

      Map<String, String[]> params = request.getParameterMap();

      try
      {
         Coord       coord           = new Coord(params);
         SubsurveyId subsurveyId     = new SubsurveyId(params);

         Inputs inputs = new Inputs(/*auth*/null, coord, subsurveyId, false);

         /* query Obscore table */

         DbPSearch dbps;
         synchronized(DbPSearch.class)
         {
            dbps = new DbPSearch();
         }
         String[] pubdidArr = dbps.queryOverlapingPubdid(coord, subsurveyId);



         final String RESPONSE_ENCODING = "UTF-8";

         /* if filters installed response will be wrapped */

         if(response instanceof FormatResponseWrapper)
         {
            LOGGER.info("response-type is FormatResponseWrapper");

            response.setContentType("text/plain");
            response.setCharacterEncoding(RESPONSE_ENCODING);

            /* collect all search description and set to wrapped response */

            SearchDescription search = new SearchDescription();
            search.pubdidArr = pubdidArr;
            search.inputs = inputs;

            FormatResponseWrapper pubdidWrapper = (FormatResponseWrapper) response;
            pubdidWrapper.set(search);
         }
         else
         {
            LOGGER.info("response-type is HttpServletResponse");

            response.setContentType("text/plain");
            response.setCharacterEncoding(RESPONSE_ENCODING);
            PrintWriter writer = response.getWriter();

            for(String pubdid : pubdidArr)
            {
               writer.println(pubdid);
            }
            writer.close();
         }
      }
      catch (IllegalArgumentException illArg)
      {
         response.sendError(HttpServletResponse.SC_BAD_REQUEST,
               "Request with incorrect parameters: " + illArg.getMessage());
         return;
      }
      catch(Exception ex)
      {
         LOGGER.info("Exception: " + ex.getMessage());
         ex.printStackTrace();
      }

      return;
   }


   private void legacyLogEntry(HttpServletRequest request) throws UnsupportedEncodingException
   {
      StringBuffer requestURL = request.getRequestURL();
      if (request.getQueryString() != null)
      {
         requestURL.append("?").append(request.getQueryString());
         String completeURL = requestURL.toString();
         String className = this.getClass().getSimpleName();
         LOGGER.info(className + " vlkb req from: "
               + request.getRemoteAddr()
               + " doGet: " + URLDecoder.decode(completeURL, "UTF-8"));
      }
   }


}

