/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer.filter;

import java.util.ArrayList;
import java.util.List;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.serializer.filter.JobFilter;

public final class PhasesFilter
implements JobFilter {
    protected final List<ExecutionPhase> phases = new ArrayList<ExecutionPhase>();

    public PhasesFilter(ExecutionPhase phase) throws NullPointerException {
        if (phase == null) {
            throw new NullPointerException("Missing execution phase! Can not ceate a PhasesFilter without at least one execution phase.");
        }
        this.phases.add(phase);
    }

    public void add(ExecutionPhase phase) {
        if (phase != null && !this.phases.contains((Object)phase)) {
            this.phases.add(phase);
        }
    }

    @Override
    public boolean match(UWSJob job) {
        if (job == null) {
            return false;
        }
        for (ExecutionPhase p : this.phases) {
            if (job.getPhase() != p) continue;
            return true;
        }
        return false;
    }
}

