
import java.util.logging.Logger;

/* for loadSubsurveys from csv */
import com.opencsv.*;
import com.opencsv.exceptions.*;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.io.IOException;

/* NOTE originally was in search/output : designed for serializing search output xml */

class Subsurvey
{
   private static final Logger LOGGER = Logger.getLogger("Subsurvey");

   String description;
   String surveyname;
   String species;
   String transition;
   double rf; // rest frequency
   String rf_unit;
   String vel_unit;
   Dataset[] datasetArr;


   Subsurvey() { datasetArr = null; }
   Subsurvey(Subsurvey ss)
   {
    this.description = ss.description;;
    this.surveyname = ss.surveyname;
    this.species = ss.species;
    this.transition = ss.transition;
    this.rf = ss.rf; 
    this.rf_unit = ss.rf_unit;
    this.vel_unit = ss.vel_unit;
      this.datasetArr = null;
   }

   String id() { return (this.surveyname + " " + this.species + " "  + this.transition); }

   boolean matches(String id) { return id.equals(this.id()); }


   static public Subsurvey findSubsurvey(Subsurvey[] dbSubsurveys, String subsurvey_id)
   {
      for(Subsurvey curr : dbSubsurveys)
      {
         if(curr.matches(subsurvey_id))
         {
            return curr;
         }
      }

      throw new AssertionError(subsurvey_id + " not found in surveys table");
   }

   public static Subsurvey[] loadSubsurveys(String csvFilename)
   {
      List<Subsurvey> subsurveyList = new ArrayList<>();

      try
      {
         // FIXME parser not robust:
         // * eats space-character also within the field:  ,  hu ha ,  --> "huha" not "hu ha"
         // * double quote used inside string not escaped: ,"blabla 25\" res",
         // * last record (line) is missing if that line is not closed with EOL
         // * UTF-8 or US-ASACII ?
         // * else ? how to validate/verify correctness

         CSVReaderHeaderAware csvReader = new CSVReaderHeaderAware(new FileReader(csvFilename));

         Map<String, String> values;

         while ((values = csvReader.readMap()) != null)
         {
            Subsurvey subsurvey = new Subsurvey();

            subsurvey.description   = values.get("description");
            subsurvey.surveyname    = values.get("name");
            subsurvey.species       = values.get("species");
            subsurvey.transition    = values.get("transition");
            subsurvey.rf            = Double.parseDouble(values.get("rest_frequency"));
            subsurvey.rf_unit       = values.get("restf_fits_unit");
            subsurvey.vel_unit      = values.get("velocity_fits_unit");

            subsurveyList.add(subsurvey);
         }


      }
      catch(IOException ex) 
      {
         LOGGER.info("Error while loading [" + csvFilename + "]: " + ex.getMessage());
         //return null;
         //throw new IllegalStateException("Error while loading " + csvFilename + " file", ex);
      }
      catch(CsvValidationException ex) 
      {
         LOGGER.info("Error while reading [" + csvFilename + "]: " + ex.getMessage());
         //return null;
         //throw new IllegalStateException("Error while reading " + csvFilename + " file", ex);
      }

      return subsurveyList.toArray(new Subsurvey[0]);
   }





}


