/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.ServletRapClient;
import it.inaf.ia2.aa.SimpleGmsClient;
import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.rap.client.ClientCredentialsRapClient;
import it.inaf.ia2.rap.client.RapClient;

public class ServiceLocator {
    private final AuthConfig authConfig = new AuthConfig();
    private final RapClient rapClient = ServiceLocator.createRapClient(this.authConfig);
    private final SimpleGmsClient gmsClient = ServiceLocator.propertySet(this.authConfig.getGmsUri()) ? new SimpleGmsClient(this.authConfig.getGmsUri()) : null;
    private final UserManager userManager = new UserManager(this.authConfig, this.rapClient, this.gmsClient);
    private static ServiceLocator instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator getInstance() {
        Class<ServiceLocator> clazz = ServiceLocator.class;
        synchronized (ServiceLocator.class) {
            if (instance == null) {
                instance = new ServiceLocator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServiceLocator() {
        this.userManager.addJwksUri(this.rapClient.getJwksEndpointUri(null));
    }

    private static RapClient createRapClient(AuthConfig conf) {
        Object rapClient;
        if (conf.getRapClientClass() == null) {
            rapClient = conf.isClientCredentials() ? new ClientCredentialsRapClient(conf.getRapBaseUri()) : new ServletRapClient(conf.getRapBaseUri());
        } else {
            try {
                rapClient = (RapClient)conf.getRapClientClass().getDeclaredConstructor(String.class).newInstance(conf.getRapBaseUri());
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (ServiceLocator.propertySet(conf.getUserAuthorizationEndpoint())) {
            rapClient.setAuthorizationEndpoint(conf.getUserAuthorizationEndpoint());
        }
        if (ServiceLocator.propertySet(conf.getAccessTokenEndpoint())) {
            rapClient.setAccessTokenEndpoint(conf.getAccessTokenEndpoint());
        }
        if (ServiceLocator.propertySet(conf.getCheckTokenEndpoint())) {
            rapClient.setCheckTokenEndpoint(conf.getCheckTokenEndpoint());
        }
        if (ServiceLocator.propertySet(conf.getClientId())) {
            rapClient.setClientId(conf.getClientId());
        }
        if (ServiceLocator.propertySet(conf.getClientSecret())) {
            rapClient.setClientSecret(conf.getClientSecret());
        }
        if (ServiceLocator.propertySet(conf.getJwksEndpoint())) {
            rapClient.setJwksEndpoint(conf.getJwksEndpoint());
        }
        if (ServiceLocator.propertySet(conf.getRapWsUserEndpoint())) {
            rapClient.setWsUserEndpoint(conf.getRapWsUserEndpoint());
        }
        return rapClient;
    }

    private static boolean propertySet(String property) {
        return property != null && !property.isBlank();
    }

    public AuthConfig getConfig() {
        return this.authConfig;
    }

    public RapClient getRapClient() {
        return this.rapClient;
    }

    public SimpleGmsClient getGmsClient() {
        return this.gmsClient;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }
}

