/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;

public class ShowHomePage
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public ShowHomePage(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Show UWS Home Page";
    }

    @Override
    public String getDescription() {
        return "Shows the UWS home page. (URL: {baseUWS_URL}, Method: HTTP-GET, No parameter)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return !urlInterpreter.hasJobList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        if (this.uws.isDefaultHomePage()) {
            String serialization;
            UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
            response.setContentType(serializer.getMimeType());
            response.setCharacterEncoding("UTF-8");
            try {
                serialization = serializer.getUWS(this.uws);
            }
            catch (Exception e) {
                if (e instanceof UWSException) throw (UWSException)e;
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "SERIALIZE", "Can't display the default home page, due to a serialization error!", e);
                throw new UWSException(204, (Throwable)e, "No home page available for this UWS service!");
            }
            if (serialization == null) throw new UWSException(204, "No home page available for this UWS service.");
            PrintWriter output = response.getWriter();
            output.print(serialization);
            output.flush();
            return true;
        }
        if (this.uws.isHomePageRedirection()) {
            this.uws.redirect(this.uws.getHomePage(), request, user, this.getName(), response);
            return true;
        }
        URL homePageUrl = new URL(this.uws.getHomePage());
        BufferedReader reader = new BufferedReader(new InputStreamReader(homePageUrl.openStream()));
        response.setContentType(this.uws.getHomePageMimeType());
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
                writer.flush();
            }
            return true;
        }
        finally {
            writer.close();
            reader.close();
        }
    }
}

