/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Parser;

public class Polygon {
    public double[] lon;
    public double[] lat;

    public static Polygon parsePolygon(Map<String, String[]> params) {
        return new Parser(params).getPolygon();
    }

    public Polygon(String value) {
        this.parsePolygon(value);
    }

    private void parsePolygon(String str) {
        boolean isEven;
        String[] arr = str.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException("POLYGON : no value, or value contains no space");
        }
        int minLen = 6;
        if (arr.length < 6) {
            throw new IllegalArgumentException("POLYGON : must have at least 6 elements delimited by space, but found " + arr.length);
        }
        boolean bl = isEven = arr.length % 2 == 0;
        if (!isEven) {
            throw new IllegalArgumentException("POLYGON must have even number of values, but has " + arr.length);
        }
        this.lon = new double[arr.length / 2];
        this.lat = new double[arr.length / 2];
        for (int ii = 0; ii < arr.length - 1; ii += 2) {
            double dbl = Double.parseDouble(arr[ii]);
            if (dbl < 0.0 || dbl > 360.0) {
                throw new IllegalArgumentException("POLYGON : first number must be in range [0,360] but found " + dbl);
            }
            this.lon[ii / 2] = dbl;
            dbl = Double.parseDouble(arr[ii + 1]);
            if (dbl < -90.0 || dbl > 90.0) {
                throw new IllegalArgumentException("POLYGON : second number must be in range [-90,90] but found " + dbl);
            }
            this.lat[ii / 2] = dbl;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POLYGON");
        int ii = 0;
        for (ii = 0; ii < this.lon.length; ++ii) {
            sb.append(" (" + String.valueOf(this.lon[ii]) + ", " + String.valueOf(this.lat[ii]) + ")");
        }
        return sb.toString();
    }
}

