/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Arrays;
import java.util.Map;
import vo.parameter.Circle;
import vo.parameter.Parser;
import vo.parameter.Polygon;

public class Range {
    public double lon1;
    public double lon2;
    public double lat1;
    public double lat2;

    public static Range parseRange(Map<String, String[]> params) {
        return new Parser(params).getRange();
    }

    public Range(String value) {
        this.parseRange(value);
    }

    public Range(double lonCenter, double latCenter, double lonWidth, double latWidth) {
        this.lon1 = lonCenter - lonWidth / 2.0;
        this.lon2 = lonCenter + lonWidth / 2.0;
        this.lat1 = latCenter - latWidth / 2.0;
        this.lat2 = latCenter + latWidth / 2.0;
    }

    public Range(Circle circle) {
        this.lon1 = circle.lon - circle.radius;
        this.lon2 = circle.lon + circle.radius;
        this.lat1 = circle.lat - circle.radius;
        this.lat2 = circle.lat + circle.radius;
    }

    public Range(Polygon polygon) {
        this.lon1 = Arrays.stream(polygon.lon).min().getAsDouble();
        this.lon2 = Arrays.stream(polygon.lon).max().getAsDouble();
        this.lat1 = Arrays.stream(polygon.lat).min().getAsDouble();
        this.lat2 = Arrays.stream(polygon.lat).max().getAsDouble();
    }

    private void parseRange(String str) {
        String[] arr = str.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException("RANGE : no value, or value contains no space");
        }
        int len = 4;
        if (arr.length != 4) {
            throw new IllegalArgumentException("RANGE : must have 4 elements delimited by space, but found " + arr.length);
        }
        double dbl = Double.parseDouble(arr[0]);
        if (dbl < 0.0 || dbl > 360.0) {
            throw new IllegalArgumentException("RANGE : first number must be in range [0,360] but found " + dbl);
        }
        this.lon1 = dbl;
        dbl = Double.parseDouble(arr[1]);
        if (dbl < 0.0 || dbl > 360.0) {
            throw new IllegalArgumentException("RANGE : first number must be in range [0,360] but found " + dbl);
        }
        this.lon2 = dbl;
        dbl = Double.parseDouble(arr[2]);
        if (dbl < -90.0 || dbl > 90.0) {
            throw new IllegalArgumentException("RANGE : second number must be in range [-90,90] but found " + dbl);
        }
        this.lat1 = dbl;
        dbl = Double.parseDouble(arr[3]);
        if (dbl < -90.0 || dbl > 90.0) {
            throw new IllegalArgumentException("RANGE : second number must be in range [-90,90] but found " + dbl);
        }
        this.lat2 = dbl;
    }

    public String toString() {
        String str = "RANGE " + Double.valueOf(this.lon1) + " " + Double.valueOf(this.lon2) + " " + Double.valueOf(this.lat1) + " " + Double.valueOf(this.lat2);
        return str;
    }
}

