/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import java.io.Serializable;
import uws.UWSException;
import uws.job.parameters.InputParamController;

public class NumericParamController
implements InputParamController,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Number minValue = null;
    protected Number defaultValue = null;
    protected Number maxValue = null;
    protected boolean allowModification = true;

    public NumericParamController() {
    }

    public NumericParamController(Number defaultValue, Number minValue, Number maxValue, boolean allowModification) {
        this.reset(defaultValue, minValue, maxValue);
        this.allowModification(allowModification);
    }

    public final Number getMinimum() {
        return this.minValue;
    }

    public void setMinimum(Number newMinValue) {
        if (newMinValue == null) {
            this.minValue = null;
        } else {
            this.minValue = this.maxValue != null && newMinValue.doubleValue() > this.maxValue.doubleValue() ? (Number)this.maxValue : (Number)newMinValue;
            if (this.defaultValue != null && this.defaultValue.doubleValue() < this.minValue.doubleValue()) {
                this.defaultValue = this.minValue;
            }
        }
    }

    public final Number getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(Number newMaxValue) {
        if (newMaxValue == null) {
            this.maxValue = null;
        } else {
            this.maxValue = this.minValue != null && newMaxValue.doubleValue() < this.minValue.doubleValue() ? (Number)this.minValue : (Number)newMaxValue;
            if (this.defaultValue != null && this.defaultValue.doubleValue() > this.maxValue.doubleValue()) {
                this.defaultValue = this.maxValue;
            }
        }
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }

    public void setDefault(Number newDefaultValue) {
        this.defaultValue = newDefaultValue == null ? null : (this.minValue != null && newDefaultValue.doubleValue() < this.minValue.doubleValue() ? (Number)this.minValue : (Number)(this.maxValue != null && newDefaultValue.doubleValue() > this.maxValue.doubleValue() ? (Number)this.maxValue : (Number)newDefaultValue));
    }

    public void reset(Number defaultVal, Number minVal, Number maxVal) {
        this.minValue = null;
        this.defaultValue = null;
        this.maxValue = null;
        this.setMinimum(minVal);
        this.setMaximum(maxVal);
        this.setDefault(defaultVal);
    }

    @Override
    public boolean allowModification() {
        return this.allowModification;
    }

    public void allowModification(boolean allowModification) {
        this.allowModification = allowModification;
    }

    @Override
    public Object check(Object value) throws UWSException {
        if (value == null) {
            return this.getDefault();
        }
        Number numVal = null;
        if (value instanceof Number) {
            numVal = (Number)value;
        } else if (value instanceof String) {
            String strValue = (String)value;
            try {
                numVal = Double.parseDouble(strValue);
            }
            catch (NumberFormatException nfe1) {
                try {
                    numVal = Long.parseLong(strValue);
                }
                catch (NumberFormatException nfe2) {
                    throw new UWSException(400, "Wrong format for a numeric parameter: \"" + strValue + "\"! It should be a double or a long value between " + (this.minValue == null ? (Number)Double.valueOf(Double.MIN_VALUE) : (Number)this.minValue) + " and " + (this.maxValue == null ? (Number)Double.valueOf(Double.MAX_VALUE) : (Number)this.maxValue) + " (Default value: " + (this.defaultValue == null ? "none" : this.defaultValue) + ").");
                }
            }
        } else {
            throw new UWSException(500, "Wrong type for a numeric parameter: class \"" + value.getClass().getName() + "\"! It should be a double, a long value or a string containing only a double or a long value.");
        }
        if (this.minValue != null && numVal.doubleValue() < this.minValue.doubleValue()) {
            return this.minValue;
        }
        if (this.maxValue != null && numVal.doubleValue() > this.maxValue.doubleValue()) {
            return this.maxValue;
        }
        return numVal;
    }
}

