
import java.util.logging.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.io.PrintWriter;


class FormatResponseSettings
{
   private static final Logger LOGGER = Logger.getLogger("FormatResponseSettings");


   public static class DBConn
   {
      private String uri;
      private String schema;
      private String user_name;
      private String password;

      public String uri() {return uri;}
      public String schema() {return schema;}
      public String userName() {return user_name;}
      public String password() {return password;}

      public String toString()
      {
         return uri + "  schema[" + schema +  "] " + user_name + " / " + password;
      }
   }


   public static class ServiceUrls
   {
      private String cutoutUrl;
      private String mergeUrl;
      private String surveysAbsPathname;
      private String respFormat;

      public boolean cutoutUrlIsSet() { return (cutoutUrl != null) && cutoutUrl.trim().isEmpty(); }
      public boolean mergeUrlIsSet()  { return (mergeUrl != null) && mergeUrl.trim().isEmpty(); }
      public boolean surveysAbsPathnameIsSet()
       { return (surveysAbsPathname != null) && surveysAbsPathname.trim().isEmpty(); }
      public boolean responseFormatIsSet() { return (respFormat != null) && respFormat.trim().isEmpty(); }

      public String cutoutUrl() {return cutoutUrl;}
      public String mergeUrl()  {return mergeUrl;}
      public String surveysAbsPathname()  {return surveysAbsPathname;}
      public String responseFormat()  {return respFormat;}

      public String toString()
      {
         return cutoutUrl + "   "  + mergeUrl + "   " + surveysAbsPathname + "    " + respFormat;
      }
   }


   public DBConn     dbConn;
   public ServiceUrls serviceUrls;


   // will not start without config-file; no reasonable code-defaults can be invented
   public static FormatResponseSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = FormatResponseSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            DBConn      dbConn      = loadDBConn(properties);
            ServiceUrls serviceUrls = loadServiceUrls(properties);

            return new FormatResponseSettings(dbConn, serviceUrls);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }




   private FormatResponseSettings(DBConn dbConn, ServiceUrls serviceUrls)
   {
      this.dbConn      = dbConn;
      this.serviceUrls = serviceUrls;
   }


   private static DBConn loadDBConn(Properties properties)
   {
      DBConn dbConn = new FormatResponseSettings.DBConn();
      dbConn.uri       = properties.getProperty("db_uri","jdbc:postgresql://localhost:5432/vialactea").strip();
      dbConn.schema    = properties.getProperty("db_schema","datasets").strip();
      dbConn.user_name = properties.getProperty("db_user_name","").strip();
      dbConn.password  = properties.getProperty("db_password","").strip();

      return dbConn;
   }


   private static ServiceUrls loadServiceUrls(Properties properties)
   {
      ServiceUrls serviceUrls = new ServiceUrls();
      serviceUrls.cutoutUrl = properties.getProperty("cutout_url","").strip();
      serviceUrls.mergeUrl  = properties.getProperty("merge_url","").strip();
      serviceUrls.surveysAbsPathname = properties.getProperty("surveys_metadata_abs_pathname","/srv/surveys/surveys_metadata.csv").strip();
      serviceUrls.respFormat = properties.getProperty("response_format","application/x-votable+xml").strip();
      return serviceUrls;
   }


}

