

import java.io.PrintWriter;
import java.util.Map;



class SubsurveyId
{
   public String surveyName;
   public String species;
   public String transition;

   public SubsurveyId(String surveyName, String species, String transition)
   {
      this.surveyName = surveyName;
      this.species    = species;
      this.transition = transition;
   }


   public SubsurveyId(Map<String, String[]> params)
   {
      this.surveyName = getFirstValue(params, "surveyname");
      this.species    = getFirstValue(params, "species");
      this.transition = getFirstValue(params, "transition");
   }

   // FIXME extend map with this and reuse in both Coord and Subsurvey
   private String getFirstValue(Map<String, String[]> map, String key)
   {
      String[] value = map.get(key);

      if(value == null)
         return null;

      if(value.length > 0)    // key-value present at least once: return first occurance
         return value[0].toString();
      else                    // length=0: no values present
         throw new IllegalArgumentException("parameter " + key + " has no value."); 
   }

   public String toString()
   {
      return surveyName + " " + species + " "+ transition;
   }


   public void toXML(PrintWriter writer)
   {
      if(surveyName  != null) writer.println("<SurveyName>"+surveyName+"</SurveyName>");
      if(species     != null) writer.println("<Species>"+species+"</Species>");
      if(transition  != null) writer.println("<Transition>"+transition+"</Transition>");
   }


}
