
import java.util.logging.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.io.PrintWriter;


class SearchSettings
{
   private static final Logger LOGGER = Logger.getLogger("SearchSettings");


   public static class DBConn
   {
      private String uri;
      private String schema;
      private String user_name;
      private String password;

      public String uri() {return uri;}
      public String schema() {return schema;}
      public String userName() {return user_name;}
      public String password() {return password;}

      public String toString()
      {
         return uri + "  schema[" + schema +  "] " + user_name + " / " + password;
      }
   }

   public DBConn     dbConn;


   // will not start without config-file; no reasonable code-defaults can be invented
   public static SearchSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = SearchSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            DBConn      dbConn      = loadDBConn(properties);

            return new SearchSettings(dbConn/*, serviceUrls*/);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }




   private SearchSettings(DBConn dbConn)
   {
      this.dbConn      = dbConn;
   }


   private static DBConn loadDBConn(Properties properties)
   {
      DBConn dbConn = new SearchSettings.DBConn();
      dbConn.uri       = properties.getProperty("db_uri","jdbc:postgresql://localhost:5432/vialactea").strip();
      dbConn.schema    = properties.getProperty("db_schema","datasets").strip();
      dbConn.user_name = properties.getProperty("db_user_name","").strip();
      dbConn.password  = properties.getProperty("db_password","").strip();

      return dbConn;
   }

}

