
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


class FormatResponseSettings
{
   public static class ServiceUrls
   {
      private String cutoutUrl;
      private String mergeUrl;

      public boolean cutoutUrlIsSet() { return (cutoutUrl != null) && cutoutUrl.trim().isEmpty(); }
      public boolean mergeUrlIsSet()  { return (mergeUrl != null) && mergeUrl.trim().isEmpty(); }

      public String cutoutUrl() {return cutoutUrl;}
      public String mergeUrl()  {return mergeUrl;}

      public String toString()
      {
         return cutoutUrl + "   "  + mergeUrl;
      }
   }

   public static FormatResponseSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = FormatResponseSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            ServiceUrls serviceUrls = loadServiceUrls(properties);

            return new FormatResponseSettings(serviceUrls);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }
      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }

   private static ServiceUrls loadServiceUrls(Properties properties)
   {
      ServiceUrls serviceUrls = new ServiceUrls();
      serviceUrls.cutoutUrl = properties.getProperty("cutout_url","").strip();
      serviceUrls.mergeUrl  = properties.getProperty("merge_url","").strip();
      return serviceUrls;
   }


   // instance

   public ServiceUrls serviceUrls;

   private FormatResponseSettings(ServiceUrls serviceUrls)
   {
      this.serviceUrls = serviceUrls;
   }
}

