
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


class SearchSettings
{
   public static SearchSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = SearchSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            DBConn dbConn = loadDBConn(properties);

            return new SearchSettings(dbConn);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }

   private static DBConn loadDBConn(Properties properties)
   {
      DBConn dbConn = new DBConn();
      dbConn.uri       = properties.getProperty("db_uri","jdbc:postgresql://localhost:5432/vialactea").strip();
      dbConn.schema    = properties.getProperty("db_schema","ivoa").strip();
      dbConn.user_name = properties.getProperty("db_user_name","").strip();
      dbConn.password  = properties.getProperty("db_password","").strip();

      return dbConn;
   }


   // instance; separate classes allow grouping of settings
   // DBConn - db_*

   public DBConn dbConn;

   private SearchSettings(DBConn dbConn)
   {
      this.dbConn = dbConn;
   }

}

