/*
 * Decompiled with CFR 0.152.
 */
package uws;

import uws.job.ExecutionPhase;
import uws.job.user.JobOwner;

public final class UWSExceptionFactory {
    private UWSExceptionFactory() {
    }

    private static final String appendMessage(String consequence) {
        return consequence == null || consequence.trim().length() > 0 ? "" : " => " + consequence;
    }

    public static final String incorrectPhaseTransition(String jobID, ExecutionPhase fromPhase, ExecutionPhase toPhase) {
        return UWSExceptionFactory.incorrectPhaseTransition(jobID, fromPhase, toPhase, null);
    }

    public static final String incorrectPhaseTransition(String jobID, ExecutionPhase fromPhase, ExecutionPhase toPhase, String consequence) {
        return "Incorrect phase transition! => the job " + jobID + " is in the phase " + (Object)((Object)fromPhase) + ". It can not go to " + (Object)((Object)toPhase) + "." + UWSExceptionFactory.appendMessage(consequence);
    }

    public static final String readPermissionDenied(JobOwner user, boolean jobList, String containerName) {
        return UWSExceptionFactory.readPermissionDenied(user, jobList, containerName, null);
    }

    public static final String readPermissionDenied(JobOwner user, boolean jobList, String containerName, String consequence) {
        return user.getID() + (user.getPseudo() == null ? "" : " (alias " + user.getPseudo() + ")") + " is not allowed to read the content of the " + (jobList ? "jobs list" : "job") + " \"" + containerName + "\"!" + UWSExceptionFactory.appendMessage(consequence);
    }

    public static final String writePermissionDenied(JobOwner user, boolean jobList, String containerName) {
        return UWSExceptionFactory.writePermissionDenied(user, jobList, containerName, null);
    }

    public static final String writePermissionDenied(JobOwner user, boolean jobList, String containerName, String consequence) {
        return user.getID() + (user.getPseudo() == null ? "" : " (alias " + user.getPseudo() + ")") + " is not allowed to update the content of the " + (jobList ? "jobs list" : "job") + " \"" + containerName + "\"!" + UWSExceptionFactory.appendMessage(consequence);
    }

    public static final String executePermissionDenied(JobOwner user, String jobID) {
        return UWSExceptionFactory.executePermissionDenied(user, jobID, null);
    }

    public static final String executePermissionDenied(JobOwner user, String jobID, String consequence) {
        return user.getID() + (user.getPseudo() == null ? "" : " (alias " + user.getPseudo() + ")") + " is not allowed to execute/abort the job \"" + jobID + "\"!" + UWSExceptionFactory.appendMessage(consequence);
    }

    public static final String jobModificationForbidden(String jobId, ExecutionPhase phase, String parameter) {
        return UWSExceptionFactory.jobModificationForbidden(jobId, phase, parameter, null);
    }

    public static final String jobModificationForbidden(String jobId, ExecutionPhase phase, String parameter, String consequence) {
        if (parameter != null && !parameter.trim().isEmpty()) {
            return "Impossible to change the parameter \"" + parameter + "\" of the job " + jobId + (phase != null ? " (phase: " + (Object)((Object)phase) + ")" : "") + "!" + UWSExceptionFactory.appendMessage(consequence);
        }
        return "Impossible to change the parameters of the job " + jobId + (phase != null ? " (phase: " + (Object)((Object)phase) + ")" : "") + "!" + UWSExceptionFactory.appendMessage(consequence);
    }
}

