/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import uws.UWSException;
import uws.job.ErrorType;
import uws.job.SerializableUWSObject;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;

public class ErrorSummary
extends SerializableUWSObject {
    private static final long serialVersionUID = 1L;
    protected String message;
    protected ErrorType type;
    protected String details = null;

    public ErrorSummary(Exception ex, ErrorType errorType, String detailedMsgURI) {
        this(ex == null ? null : ex.getMessage(), errorType, detailedMsgURI);
    }

    public ErrorSummary(String msg, ErrorType errorType) {
        this(msg, errorType, (String)null);
    }

    public ErrorSummary(String msg, ErrorType errorType, String detailedMsgURI) {
        this.message = msg == null ? "{No error message}" : msg;
        this.type = errorType == null ? ErrorType.FATAL : errorType;
        this.details = detailedMsgURI == null || detailedMsgURI.trim().length() == 0 ? null : detailedMsgURI.trim();
    }

    public final String getMessage() {
        return this.message;
    }

    public final ErrorType getType() {
        return this.type;
    }

    public final boolean hasDetail() {
        return this.details != null;
    }

    public final String getDetails() {
        return this.details;
    }

    @Override
    public String serialize(UWSSerializer serializer, JobOwner owner) throws UWSException, Exception {
        return serializer.getErrorSummary(this, true);
    }

    public String toString() {
        return "ERROR_SUMMARY {type: " + this.type.name() + "; message: \"" + this.message + "\"; details: " + (this.hasDetail() ? this.details : "none") + "}";
    }
}

