/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSUrl;
import uws.service.request.UploadFile;

public class XMLSerializer
extends UWSSerializer {
    private static final long serialVersionUID = 1L;
    protected String tabPrefix = "";
    protected String xsltPath = null;
    private static final String XML_START_NODE_NAME_REGEX = ":A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}";
    private static final String XML_NODE_NAME_REGEX = "[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}][:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}\\-.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*";

    public XMLSerializer() {
    }

    public XMLSerializer(String xsltPath) {
        this.xsltPath = xsltPath;
    }

    public final String getXSLTPath() {
        return this.xsltPath;
    }

    public final void setXSLTPath(String path) {
        if (path == null) {
            this.xsltPath = null;
        } else {
            this.xsltPath = path.trim();
            if (this.xsltPath.isEmpty()) {
                this.xsltPath = null;
            }
        }
    }

    public String getHeader() {
        StringBuffer xmlHeader = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.xsltPath != null) {
            xmlHeader.append("<?xml-stylesheet type=\"text/xsl\" href=\"").append(XMLSerializer.escapeXMLAttribute(this.xsltPath)).append("\"?>\n");
        }
        return xmlHeader.toString();
    }

    public String getUWSNamespace() {
        return "xmlns=\"http://www.ivoa.net/xml/UWS/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ivoa.net/xml/UWS/v1.0 http://www.ivoa.net/xml/UWS/v1.0 http://www.w3.org/1999/xlink http://www.w3.org/1999/xlink.xsd http://www.w3.org/2001/XMLSchema http://www.w3.org/2001/XMLSchema.xsd\"";
    }

    protected final String getUWSNamespace(boolean root) {
        if (root) {
            return " " + this.getUWSNamespace();
        }
        return "";
    }

    @Override
    public final String getMimeType() {
        return "text/xml";
    }

    @Override
    public String getUWS(UWS uws, JobOwner user) {
        String name = uws.getName();
        String description = uws.getDescription();
        StringBuffer xml = new StringBuffer(this.getHeader());
        xml.append("<uws version=\"").append("1.1").append('\"').append(this.getUWSNamespace(true));
        if (name != null) {
            xml.append(" name=\"").append(XMLSerializer.escapeXMLAttribute(name)).append('\"');
        }
        xml.append(">\n");
        if (description != null) {
            xml.append("\t<description>\n").append(XMLSerializer.escapeXMLData(description)).append("\n\t</description>\n");
        }
        xml.append("\t<jobLists>\n");
        for (JobList jobList : uws) {
            UWSUrl jlUrl = jobList.getUrl();
            xml.append("\t\t<jobListRef name=\"").append(XMLSerializer.escapeXMLAttribute(jobList.getName())).append('\"');
            if (jlUrl != null && jlUrl.getRequestURL() != null) {
                xml.append(" xlink:type=\"simple\" xlink:href=\"").append(XMLSerializer.escapeXMLAttribute(jlUrl.getRequestURL())).append('\"');
            }
            xml.append(" />\n");
        }
        xml.append("\t</jobLists>\n");
        xml.append("</uws>\n");
        return xml.toString();
    }

    @Override
    public String getJobList(JobList jobsList, JobOwner owner, JobListRefiner listRefiner, boolean root) throws Exception {
        StringBuffer xml = new StringBuffer(this.getHeader());
        xml.append("<jobs version=\"").append("1.1").append('\"').append(this.getUWSNamespace(true));
        xml.append('>');
        UWSUrl jobsListUrl = jobsList.getUrl();
        Iterator<UWSJob> it = jobsList.getJobs(owner);
        if (listRefiner != null) {
            it = listRefiner.refine(it);
        }
        while (it.hasNext()) {
            xml.append("\n\t").append(this.getJobRef(it.next(), jobsListUrl));
        }
        xml.append("\n</jobs>");
        return xml.toString();
    }

    @Override
    public String getJob(UWSJob job, boolean root) throws UWSException {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        String newLine = "\n\t";
        xml.append("<job version=\"").append("1.1").append('\"').append(this.getUWSNamespace(root)).append('>');
        xml.append(newLine).append(this.getJobID(job, false));
        if (job.getRunId() != null) {
            xml.append(newLine).append(this.getRunID(job, false));
        }
        xml.append(newLine).append(this.getOwnerID(job, false));
        xml.append(newLine).append(this.getPhase(job, false));
        xml.append(newLine).append(this.getQuote(job, false));
        xml.append(newLine).append(this.getCreationTime(job, false));
        xml.append(newLine).append(this.getStartTime(job, false));
        xml.append(newLine).append(this.getEndTime(job, false));
        xml.append(newLine).append(this.getExecutionDuration(job, false));
        xml.append(newLine).append(this.getDestructionTime(job, false));
        this.tabPrefix = "\t";
        newLine = "\n";
        xml.append(newLine).append(this.getAdditionalParameters(job, false));
        xml.append(newLine).append(this.getResults(job, false));
        if (job.getErrorSummary() != null) {
            xml.append(newLine).append(this.getErrorSummary(job.getErrorSummary(), false));
        }
        if (job.getJobInfo() != null) {
            xml.append(newLine).append(this.getJobInfo(job));
        }
        this.tabPrefix = "";
        return xml.append("\n</job>").toString();
    }

    @Override
    public String getJobRef(UWSJob job, UWSUrl jobsListUrl) {
        String url = null;
        if (jobsListUrl != null) {
            jobsListUrl.setJobId(job.getJobId());
            url = jobsListUrl.getRequestURL();
        }
        StringBuffer xml = new StringBuffer("<jobref id=\"");
        xml.append(XMLSerializer.escapeXMLAttribute(job.getJobId())).append('\"');
        if (url != null) {
            xml.append(" xlink:type=\"simple\" xlink:href=\"").append(XMLSerializer.escapeXMLAttribute(url)).append('\"');
        }
        xml.append('>');
        xml.append("\n\t\t").append(this.getPhase(job, false));
        if (job.getRunId() != null) {
            xml.append("\n\t\t").append(this.getRunID(job, false));
        }
        if (job.getOwner() != null) {
            xml.append("\n\t\t").append(this.getOwnerID(job, false));
        }
        xml.append("\n\t\t").append(this.getCreationTime(job, false));
        xml.append("\n\t</jobref>");
        return xml.toString();
    }

    @Override
    public String getJobID(UWSJob job, boolean root) {
        return new StringBuffer(root ? this.getHeader() : "").append("<jobId").append(this.getUWSNamespace(root)).append('>').append(XMLSerializer.escapeXMLData(job.getJobId())).append("</jobId>").toString();
    }

    @Override
    public String getRunID(UWSJob job, boolean root) {
        if (job.getRunId() != null) {
            StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
            xml.append("<runId").append(this.getUWSNamespace(root));
            xml.append('>').append(XMLSerializer.escapeXMLData(job.getRunId())).append("</runId>");
            return xml.toString();
        }
        return "";
    }

    @Override
    public String getOwnerID(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<ownerId").append(this.getUWSNamespace(root));
        if (job.getOwner() == null) {
            xml.append(" xsi:nil=\"true\" />");
        } else {
            xml.append('>').append(XMLSerializer.escapeXMLData(job.getOwner().getPseudo())).append("</ownerId>");
        }
        return xml.toString();
    }

    @Override
    public String getPhase(UWSJob job, boolean root) {
        return new StringBuffer(root ? this.getHeader() : "").append("<phase").append(this.getUWSNamespace(root)).append('>').append((Object)job.getPhase()).append("</phase>").toString();
    }

    @Override
    public String getQuote(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<quote").append(this.getUWSNamespace(root));
        if (job.getStartTime() == null || job.getQuote() <= 0L) {
            xml.append(" xsi:nil=\"true\" />");
        } else {
            long quoteTime = job.getStartTime().getTime() + 1000L * job.getQuote();
            xml.append('>').append(ISO8601Format.format(quoteTime)).append("</quote>");
        }
        return xml.toString();
    }

    @Override
    public String getCreationTime(UWSJob job, boolean root) {
        return new StringBuffer(root ? this.getHeader() : "").append("<creationTime").append(this.getUWSNamespace(root)).append('>').append(ISO8601Format.format(job.getCreationTime())).append("</creationTime>").toString();
    }

    @Override
    public String getStartTime(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<startTime").append(this.getUWSNamespace(root));
        if (job.getStartTime() == null) {
            xml.append(" xsi:nil=\"true\" />");
        } else {
            xml.append('>').append(ISO8601Format.format(job.getStartTime())).append("</startTime>");
        }
        return xml.toString();
    }

    @Override
    public String getEndTime(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<endTime").append(this.getUWSNamespace(root));
        if (job.getEndTime() == null) {
            xml.append(" xsi:nil=\"true\" />");
        } else {
            xml.append('>').append(ISO8601Format.format(job.getEndTime())).append("</endTime>");
        }
        return xml.toString();
    }

    @Override
    public String getDestructionTime(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<destruction").append(this.getUWSNamespace(root));
        if (job.getDestructionTime() == null) {
            xml.append(" xsi:nil=\"true\" />");
        } else {
            xml.append('>').append(ISO8601Format.format(job.getDestructionTime())).append("</destruction>");
        }
        return xml.toString();
    }

    @Override
    public String getExecutionDuration(UWSJob job, boolean root) {
        return new StringBuffer(root ? this.getHeader() : "").append("<executionDuration").append(this.getUWSNamespace(root)).append('>').append(job.getExecutionDuration()).append("</executionDuration>").toString();
    }

    @Override
    public String getErrorSummary(ErrorSummary error, boolean root) {
        if (error != null) {
            StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
            xml.append(this.tabPrefix).append("<errorSummary").append(this.getUWSNamespace(root));
            xml.append(" type=\"").append((Object)error.getType()).append('\"').append(" hasDetail=\"").append(error.hasDetail()).append("\">");
            xml.append("\n\t").append(this.tabPrefix).append("<message>").append(XMLSerializer.escapeXMLData(error.getMessage())).append("</message>");
            xml.append('\n').append(this.tabPrefix).append("</errorSummary>");
            return xml.toString();
        }
        return "";
    }

    @Override
    public String getAdditionalParameters(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append(this.tabPrefix).append("<parameters").append(this.getUWSNamespace(root)).append(">");
        String newLine = "\n\t" + this.tabPrefix;
        for (String paramName : job.getAdditionalParameters()) {
            xml.append(newLine).append(this.getAdditionalParameter(paramName, job.getAdditionalParameterValue(paramName), false));
        }
        xml.append('\n').append(this.tabPrefix).append("</parameters>");
        return xml.toString();
    }

    @Override
    public String getAdditionalParameter(String paramName, Object paramValue, boolean root) {
        if (paramName != null && paramValue != null) {
            if (root) {
                if (paramValue.getClass().isArray()) {
                    StringBuffer buf = new StringBuffer();
                    for (Object o : (Object[])paramValue) {
                        if (buf.length() > 0) {
                            buf.append(';');
                        }
                        buf.append(o.toString());
                    }
                    return buf.toString();
                }
                return paramValue.toString();
            }
            StringBuffer buf = new StringBuffer();
            if (paramValue.getClass().isArray()) {
                for (Object o : (Object[])paramValue) {
                    if (buf.length() > 0) {
                        buf.append("\n\t").append(this.tabPrefix);
                    }
                    buf.append(this.getAdditionalParameter(paramName, o, root));
                }
            } else {
                buf.append("<parameter").append(this.getUWSNamespace(root)).append(" id=\"").append(XMLSerializer.escapeXMLAttribute(paramName)).append('\"');
                if (paramValue instanceof UploadFile) {
                    buf.append(" byReference=\"true\"");
                }
                buf.append('>').append(XMLSerializer.escapeXMLData(paramValue.toString())).append("</parameter>");
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public String getResults(UWSJob job, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append(this.tabPrefix).append("<results").append(this.getUWSNamespace(root)).append(">");
        Iterator<Result> it = job.getResults();
        String newLine = "\n\t" + this.tabPrefix;
        while (it.hasNext()) {
            xml.append(newLine).append(this.getResult(it.next(), false));
        }
        xml.append('\n').append(this.tabPrefix).append("</results>");
        return xml.toString();
    }

    @Override
    public String getResult(Result result, boolean root) {
        StringBuffer xml = new StringBuffer(root ? this.getHeader() : "");
        xml.append("<result").append(this.getUWSNamespace(root)).append(" id=\"").append(XMLSerializer.escapeXMLAttribute(result.getId())).append('\"');
        if (result.getHref() != null) {
            xml.append(" xlink:type=\"").append(result.getType() == null ? "simple" : XMLSerializer.escapeXMLAttribute(result.getType())).append('\"');
            xml.append(" xlink:href=\"").append(XMLSerializer.escapeXMLAttribute(result.getHref())).append('\"');
        }
        if (result.getMimeType() != null) {
            xml.append(" mime-type=\"").append(XMLSerializer.escapeXMLAttribute(result.getMimeType())).append('\"');
        }
        if (result.getSize() >= 0L) {
            xml.append(" size=\"").append(result.getSize()).append('\"');
        }
        return xml.append(" />").toString();
    }

    public String getJobInfo(UWSJob job) throws UWSException {
        if (job.getJobInfo() != null) {
            StringBuffer xml = new StringBuffer();
            xml.append(this.tabPrefix).append("<jobInfo>");
            xml.append("\n\t").append(this.tabPrefix).append(job.getJobInfo().getXML("\n\t" + this.tabPrefix));
            xml.append('\n').append(this.tabPrefix).append("</jobInfo>");
            return xml.toString();
        }
        return "";
    }

    public static String escapeXMLData(String data) {
        StringBuffer encoded = new StringBuffer();
        block5: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '&': {
                    encoded.append("&amp;");
                    continue block5;
                }
                case '<': {
                    encoded.append("&lt;");
                    continue block5;
                }
                case '>': {
                    encoded.append("&gt;");
                    continue block5;
                }
                default: {
                    encoded.append(XMLSerializer.ensureLegalXml(c));
                }
            }
        }
        return encoded.toString();
    }

    public static String escapeXMLAttribute(String value) {
        StringBuffer encoded = new StringBuffer();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    encoded.append("&amp;");
                    continue block6;
                }
                case '<': {
                    encoded.append("&lt;");
                    continue block6;
                }
                case '>': {
                    encoded.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    encoded.append("&quot;");
                    continue block6;
                }
                default: {
                    encoded.append(XMLSerializer.ensureLegalXml(c));
                }
            }
        }
        return encoded.toString();
    }

    public static String escapeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return XMLSerializer.escapeXMLAttribute(url);
        }
    }

    public static char ensureLegalXml(char c) {
        return (char)(c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c == 9 || c == 10 || c == 13 ? c : 191);
    }

    public static boolean isValidXMLNodeName(String nodeName) {
        return nodeName.matches(XML_NODE_NAME_REGEX) && !nodeName.toLowerCase().startsWith("xml");
    }
}

