/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.UWSToolBox;
import uws.service.file.UWSFileManager;
import uws.service.request.FormEncodedParser;
import uws.service.request.MultipartParser;
import uws.service.request.RequestParser;
import uws.service.request.XMLRequestParser;

public final class UWSRequestParser
implements RequestParser {
    private final UWSFileManager fileManager;
    private RequestParser formParser = null;
    private RequestParser multipartParser = null;
    private RequestParser xmlRequestParser = null;

    public UWSRequestParser(UWSFileManager fileManager) {
        if (fileManager == null) {
            throw new NullPointerException("Missing file manager => can not create a UWSRequestParser!");
        }
        this.fileManager = fileManager;
    }

    @Override
    public Map<String, Object> parse(HttpServletRequest req) throws UWSException {
        String method;
        if (req == null) {
            return new HashMap<String, Object>();
        }
        String string = method = req.getMethod() == null ? "" : req.getMethod().toLowerCase();
        if (method.equals("post") || method.equals("put")) {
            Map<Object, Object> params = null;
            params = FormEncodedParser.isFormEncodedRequest(req) ? this.getFormParser().parse(req) : (MultipartParser.isMultipartContent(req) ? this.getMultipartParser().parse(req) : (XMLRequestParser.isXMLRequest(req) ? this.getXMLRequestParser().parse(req) : new HashMap<String, Object>(0)));
            if (method.equals("post")) {
                params = UWSToolBox.addGETParameters(req, params == null ? new HashMap() : params);
            }
            return params;
        }
        return UWSToolBox.addGETParameters(req, new HashMap<String, Object>());
    }

    private final synchronized RequestParser getFormParser() {
        return this.formParser == null ? (this.formParser = new FormEncodedParser()) : this.formParser;
    }

    private final synchronized RequestParser getMultipartParser() {
        return this.multipartParser == null ? (this.multipartParser = new MultipartParser(this.fileManager)) : this.multipartParser;
    }

    private final synchronized RequestParser getXMLRequestParser() {
        return this.xmlRequestParser == null ? (this.xmlRequestParser = new XMLRequestParser(this.fileManager)) : this.xmlRequestParser;
    }
}

