/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.lang.CollectionMutator;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;

public class DefaultCollectionMutator<E, M extends CollectionMutator<E, M>>
implements CollectionMutator<E, M> {
    private final Collection<E> collection;

    public DefaultCollectionMutator(Collection<? extends E> seed) {
        this.collection = new LinkedHashSet(Collections.nullSafe(seed));
    }

    protected final M self() {
        return (M)this;
    }

    public M add(E e) {
        if (Objects.isEmpty(e)) {
            return this.self();
        }
        if (e instanceof Identifiable && !Strings.hasText((String)((Identifiable)e).getId())) {
            String msg = e.getClass() + " getId() value cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        this.collection.remove(e);
        this.collection.add(e);
        return this.self();
    }

    public M remove(E e) {
        this.collection.remove(e);
        return this.self();
    }

    public M add(Collection<? extends E> c) {
        for (Object element : Collections.nullSafe(c)) {
            this.add(element);
        }
        return this.self();
    }

    public M clear() {
        this.collection.clear();
        return this.self();
    }

    protected Collection<E> getCollection() {
        return Collections.immutable(this.collection);
    }
}

