/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.quant;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.provider.param.base.CompressHeaderParameter;
import nom.tam.fits.header.Compression;

final class ZQuantizeParameter
extends CompressHeaderParameter<QuantizeOption> {
    ZQuantizeParameter(QuantizeOption quantizeOption) {
        super(Compression.ZQUANTIZ.name(), quantizeOption);
    }

    @Override
    public void getValueFromHeader(Header header) {
        String value = header.getStringValue(this.getName());
        if ("SUBTRACTIVE_DITHER_2".equals(value)) {
            ((QuantizeOption)this.getOption()).setDither(true);
            ((QuantizeOption)this.getOption()).setDither2(true);
        } else if ("SUBTRACTIVE_DITHER_1".equals(value)) {
            ((QuantizeOption)this.getOption()).setDither(true);
            ((QuantizeOption)this.getOption()).setDither2(false);
        } else {
            ((QuantizeOption)this.getOption()).setDither(false);
            ((QuantizeOption)this.getOption()).setDither2(false);
        }
    }

    @Override
    public void setValueInHeader(Header header) throws HeaderCardException {
        String value = ((QuantizeOption)this.getOption()).isDither2() ? "SUBTRACTIVE_DITHER_2" : (((QuantizeOption)this.getOption()).isDither() ? "SUBTRACTIVE_DITHER_1" : "NO_DITHER");
        header.card(Compression.ZQUANTIZ).value(value);
    }
}

