/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.Buffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.util.type.PrimitiveType;

public final class PrimitiveTypeHandler {
    private static final int BIT_PIX_OFFSET = 64;
    private static PrimitiveType<?>[] byBitPix = new PrimitiveType[129];
    private static Map<Class<?>, PrimitiveType<? extends Buffer>> byClass;

    private static <B extends Buffer> PrimitiveType<B> cast(PrimitiveType<?> primitiveType) {
        return primitiveType;
    }

    public static <B extends Buffer> PrimitiveType<B> valueOf(Class<?> clazz) {
        PrimitiveType<? extends Buffer> primitiveType = byClass.get(clazz);
        if (primitiveType == null) {
            for (Class<?> interf : clazz.getInterfaces()) {
                primitiveType = byClass.get(interf);
                if (primitiveType == null) continue;
                return PrimitiveTypeHandler.cast(primitiveType);
            }
            return PrimitiveTypeHandler.valueOf(clazz.getSuperclass());
        }
        return PrimitiveTypeHandler.cast(primitiveType);
    }

    private static PrimitiveType<?>[] values() {
        return new PrimitiveType[]{PrimitiveType.BOOLEAN, PrimitiveType.BYTE, PrimitiveType.CHAR, PrimitiveType.DOUBLE, PrimitiveType.FLOAT, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.SHORT, PrimitiveType.STRING, PrimitiveType.UNKNOWN};
    }

    private PrimitiveTypeHandler() {
    }

    public static PrimitiveType<Buffer> valueOf(int bitPix) {
        return PrimitiveTypeHandler.cast(byBitPix[bitPix + 64]);
    }

    static {
        HashMap initialByClass = new HashMap();
        for (PrimitiveType<?> type : PrimitiveTypeHandler.values()) {
            if (type.bitPix() != 0) {
                PrimitiveTypeHandler.byBitPix[type.bitPix() + 64] = type;
            }
            initialByClass.put(type.primitiveClass(), type);
            initialByClass.put(type.wrapperClass(), type);
            if (type.bufferClass() == null) continue;
            initialByClass.put(type.bufferClass(), type);
        }
        byClass = Collections.unmodifiableMap(initialByClass);
    }
}

