
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


class FormatResponseSettings
{
   public static class ServiceUrls
   {
      private String cutoutUrl;

      public boolean cutoutUrlIsSet() { return (cutoutUrl != null) && cutoutUrl.trim().isEmpty(); }

      public String cutoutUrl() {return cutoutUrl;}

      public String toString()
      {
         return cutoutUrl;
      }
   }

   public static FormatResponseSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = FormatResponseSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            ServiceUrls serviceUrls = loadServiceUrls(properties);

            return new FormatResponseSettings(serviceUrls);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }
      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }

   private static ServiceUrls loadServiceUrls(Properties properties)
   {
      ServiceUrls serviceUrls = new ServiceUrls();
      serviceUrls.cutoutUrl = properties.getProperty("cutout_url","").strip();
      return serviceUrls;
   }


   // instance

   public ServiceUrls serviceUrls;

   private FormatResponseSettings(ServiceUrls serviceUrls)
   {
      this.serviceUrls = serviceUrls;
   }
}

