

import uk.ac.starlink.table.*;// ColumnInfo needed
import uk.ac.starlink.votable.*;

class ObscoreExt
{
   static private ColumnInfo genPubDidColInfo()
   {
      ColumnInfo colInfo = new ColumnInfo( "obs_publisher_did", String.class,  "Publisher Did" );
      colInfo.setAuxDatum(new DescribedValue(VOStarTable.ID_INFO, "primaryID"));
      return colInfo;
   }

   static private ColumnInfo genIntWithNullColInfo(String colLabel, String colDesc)
   {
      ColumnInfo colInfo = new ColumnInfo( colLabel, Integer.class,  colDesc );
      colInfo.setAuxDatum(new DescribedValue(Tables.NULL_VALUE_INFO, Integer.MIN_VALUE));
      return colInfo;
   }


   static private ColumnInfo genLongWithNullColInfo(String colLabel, String colDesc)
   {
      ColumnInfo colInfo = new ColumnInfo( colLabel, Long.class,  colDesc );
      colInfo.setAuxDatum(new DescribedValue(Tables.NULL_VALUE_INFO, Long.MIN_VALUE));
      return colInfo;
   }



   public static final ColumnInfo[] OBSCORE_COLINFO =
   {

      new ColumnInfo( "dataproduct_type",  String.class,  "Dataproduct Type (image|cube)" ),
      genIntWithNullColInfo("calib_level", "Calibration level" ),
      new ColumnInfo( "obs_collection",    String.class,  "Collection" ),
      new ColumnInfo( "obs_title",         String.class,  "Title" ),
      new ColumnInfo( "obs_id",            String.class,  "Observation Id" ),
      genPubDidColInfo(),
      new ColumnInfo( "bib_reference",     String.class,  "Bibbliographic refererence" ),
      new ColumnInfo( "data_rights",       String.class,  "Data rights" ),

      new ColumnInfo( "access_url",     String.class, "Access URL" ),
      new ColumnInfo( "access_format",  String.class, "Format (MIME type)" ),
      genLongWithNullColInfo("access_estsize", "Extimated size (KB)" ),

      new ColumnInfo( "target_name", String.class,  "Target" ),

      new ColumnInfo( "s_ra",         Double.class, "Right Ascention" ),
      new ColumnInfo( "s_dec",        Double.class, "Declination" ),
      new ColumnInfo( "s_fov",        Double.class, "Field of view" ),
      new ColumnInfo( "s_region",     String.class, "Region" ),
      genLongWithNullColInfo("s_xel1", "Pixels axis1" ),
      genLongWithNullColInfo("s_xel2", "Pixels axis2" ),
      new ColumnInfo( "s_resolution", Double.class, "Spatial resolution" ),

      new ColumnInfo( "t_min",        Double.class, "Time min" ),
      new ColumnInfo( "t_max",        Double.class, "Time max" ),
      new ColumnInfo( "t_exptime",    Double.class, "Exposure time" ),
      new ColumnInfo( "t_resolution", Double.class, "Time resolution" ),
      genLongWithNullColInfo("t_xel", "Time pixels" ),

      new ColumnInfo( "em_min",       Double.class, "Spectrum min" ),
      new ColumnInfo( "em_max",       Double.class, "Spectrum max" ),
      new ColumnInfo( "em_res_power", Double.class, "Spectrum resolution power" ),
      genLongWithNullColInfo("em_xel", "Spectrum pixels" ),

      new ColumnInfo( "o_ucd", String.class, "Observable UCD" ),

      new ColumnInfo( "pol_states", String.class, "Polarization states" ),
      genLongWithNullColInfo("pol_xel", "Polarization pixels" ),

      new ColumnInfo( "facility_name", String.class, "Facility" ),
      new ColumnInfo( "instrument_name", String.class, "Instrument" ),
   };

   public static Object[] obscoreRow( DbObstap.ObsCore obsCore )
   {
      return new Object[]
      {
         obsCore.dataproduct_type,
            obsCore.calib_level,
            obsCore.obs_collection,
            obsCore.obs_title,
            obsCore.obs_id,
            obsCore.obs_publisher_did,
            obsCore.bib_reference,
            obsCore.data_rights,

            obsCore.access_url,
            obsCore.access_format,
            obsCore.access_estsize,

            obsCore.target_name,

            obsCore.s_ra,
            obsCore.s_dec,
            obsCore.s_fov,

            obsCore.s_region,
            obsCore.s_xel1,
            obsCore.s_xel2,
            obsCore.s_resolution,

            obsCore.t_min,
            obsCore.t_max,
            obsCore.t_exptime,
            obsCore.t_resolution,
            obsCore.t_xel,

            obsCore.em_min,
            obsCore.em_max,
            obsCore.em_res_power,
            obsCore.em_xel,

            obsCore.o_ucd,

            obsCore.pol_states,
            obsCore.pol_xel,

            obsCore.facility_name,
            obsCore.instrument_name,
      };
   }



   public static final ColumnInfo[] VLKB_COLINFO =
   {
      genIntWithNullColInfo("overlap", "Overlap Code" ),
      genIntWithNullColInfo("overlapSky", "Overlap Code for Sky axes" ),
      genIntWithNullColInfo("overlapSpec", "Overlap Code for Spectral axis" ),

      new ColumnInfo( "s_region_galactic", String.class, "Region [GALACTIC]" ),

      new ColumnInfo( "vel_min",    Double.class, "Velocity min" ),
      new ColumnInfo( "vel_max",    Double.class, "Velocity max" ),
   };

   public static Object[] vlkbRow( DbObstap.ObsCore obsCore )
   {
      return new Object[]
      {
         obsCore.overlapCode,
            obsCore.overlapCodeSky,
            obsCore.overlapCodeVel,

            obsCore.s_region_galactic,

            obsCore.vel_min,
            obsCore.vel_max,
      };
   }



   public static final ColumnInfo[] OBSCORE_VLKB_COLINFO = concat(OBSCORE_COLINFO, VLKB_COLINFO);

   public static Object[] obscoreVlkbRow( DbObstap.ObsCore obsCore )
   {
      return concat(obscoreRow(obsCore),vlkbRow(obsCore));
   }



   private static ColumnInfo[] concat(ColumnInfo[] arr1, ColumnInfo[] arr2)
   {
      ColumnInfo[] oc = new ColumnInfo[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };

   private static Object[] concat(Object[] arr1, Object[] arr2)
   {
      Object[] oc = new Object[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };
}

