

import uk.ac.starlink.table.*;// ColumnInfo needed
import uk.ac.starlink.votable.*;

class VoTableObstap
{
   static private ColumnInfo genPubDidColInfo()
   {
      ColumnInfo colInfo = new ColumnInfo( "obs_publisher_did", String.class,  "Publisher Did" );
      colInfo.setAuxDatum(new DescribedValue(VOStarTable.ID_INFO, "primaryID"));
      return colInfo;
   }

   static private ColumnInfo genIntWithNullColInfo(String colLabel, String colDesc)
   {
      ColumnInfo colInfo = new ColumnInfo( colLabel, Integer.class,  colDesc );
      colInfo.setAuxDatum(new DescribedValue(Tables.NULL_VALUE_INFO, Integer.MIN_VALUE));
      return colInfo;
   }


   static private ColumnInfo genLongWithNullColInfo(String colLabel, String colDesc)
   {
      ColumnInfo colInfo = new ColumnInfo( colLabel, Long.class,  colDesc );
      colInfo.setAuxDatum(new DescribedValue(Tables.NULL_VALUE_INFO, Long.MIN_VALUE));
      return colInfo;
   }



   public static final ColumnInfo[] OBSTAP_COLINFO =
   {

      new ColumnInfo( "dataproduct_type",  String.class,  "Dataproduct Type (image|cube)" ),
      genIntWithNullColInfo("calib_level", "Calibration level" ),
      new ColumnInfo( "obs_collection",    String.class,  "Collection" ),
      new ColumnInfo( "obs_title",         String.class,  "Title" ),
      new ColumnInfo( "obs_id",            String.class,  "Observation Id" ),
      genPubDidColInfo(),
      new ColumnInfo( "bib_reference",     String.class,  "Bibbliographic refererence" ),
      new ColumnInfo( "data_rights",       String.class,  "Data rights" ),

      new ColumnInfo( "access_url",     String.class, "Access URL" ),
      new ColumnInfo( "access_format",  String.class, "Format (MIME type)" ),
      genLongWithNullColInfo("access_estsize", "Extimated size (KB)" ),

      new ColumnInfo( "target_name", String.class,  "Target" ),

      new ColumnInfo( "s_ra",         Double.class, "Right Ascention" ),
      new ColumnInfo( "s_dec",        Double.class, "Declination" ),
      new ColumnInfo( "s_fov",        Double.class, "Field of view" ),
      new ColumnInfo( "s_region",     String.class, "Region" ),
      genLongWithNullColInfo("s_xel1", "Pixels axis1" ),
      genLongWithNullColInfo("s_xel2", "Pixels axis2" ),
      new ColumnInfo( "s_resolution", Double.class, "Spatial resolution" ),

      new ColumnInfo( "t_min",        Double.class, "Time min" ),
      new ColumnInfo( "t_max",        Double.class, "Time max" ),
      new ColumnInfo( "t_exptime",    Double.class, "Exposure time" ),
      new ColumnInfo( "t_resolution", Double.class, "Time resolution" ),
      genLongWithNullColInfo("t_xel", "Time pixels" ),

      new ColumnInfo( "em_min",       Double.class, "Spectrum min" ),
      new ColumnInfo( "em_max",       Double.class, "Spectrum max" ),
      new ColumnInfo( "em_res_power", Double.class, "Spectrum resolution power" ),
      genLongWithNullColInfo("em_xel", "Spectrum pixels" ),

      new ColumnInfo( "o_ucd", String.class, "Observable UCD" ),

      new ColumnInfo( "pol_states", String.class, "Polarization states" ),
      genLongWithNullColInfo("pol_xel", "Polarization pixels" ),

      new ColumnInfo( "facility_name", String.class, "Facility" ),
      new ColumnInfo( "instrument_name", String.class, "Instrument" ),
   };

   public static Object[] obstapRow( DbObstap.Obstap obstap )
   {
      return new Object[]
      {
         obstap.dataproduct_type,
            obstap.calib_level,
            obstap.obs_collection,
            obstap.obs_title,
            obstap.obs_id,
            obstap.obs_publisher_did,
            obstap.bib_reference,
            obstap.data_rights,

            obstap.access_url,
            obstap.access_format,
            obstap.access_estsize,

            obstap.target_name,

            obstap.s_ra,
            obstap.s_dec,
            obstap.s_fov,

            obstap.s_region,
            obstap.s_xel1,
            obstap.s_xel2,
            obstap.s_resolution,

            obstap.t_min,
            obstap.t_max,
            obstap.t_exptime,
            obstap.t_resolution,
            obstap.t_xel,

            obstap.em_min,
            obstap.em_max,
            obstap.em_res_power,
            obstap.em_xel,

            obstap.o_ucd,

            obstap.pol_states,
            obstap.pol_xel,

            obstap.facility_name,
            obstap.instrument_name,
      };
   }



   public static final ColumnInfo[] VLKB_COLINFO =
   {
      genIntWithNullColInfo("overlap", "Overlap Code" ),
      genIntWithNullColInfo("overlapSky", "Overlap Code for Sky axes" ),
      genIntWithNullColInfo("overlapSpec", "Overlap Code for Spectral axis" ),

      new ColumnInfo( "s_region_galactic", String.class, "Region [GALACTIC]" ),

      new ColumnInfo( "vel_min",    Double.class, "Velocity min" ),
      new ColumnInfo( "vel_max",    Double.class, "Velocity max" ),
   };

   public static Object[] vlkbRow( DbObstap.Obstap obstap )
   {
      return new Object[]
      {
         obstap.overlapCode,
            obstap.overlapCodeSky,
            obstap.overlapCodeVel,

            obstap.s_region_galactic,

            obstap.vel_min,
            obstap.vel_max,
      };
   }



   public static final ColumnInfo[] OBSTAP_VLKB_COLINFO = concat(OBSTAP_COLINFO, VLKB_COLINFO);

   public static Object[] obstapVlkbRow( DbObstap.Obstap obstap )
   {
      return concat( obstapRow(obstap), vlkbRow(obstap) );
   }



   private static ColumnInfo[] concat(ColumnInfo[] arr1, ColumnInfo[] arr2)
   {
      ColumnInfo[] oc = new ColumnInfo[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };

   private static Object[] concat(Object[] arr1, Object[] arr2)
   {
      Object[] oc = new Object[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };
}

