/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCardCountingArrayDataInput;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.NonStandard;
import nom.tam.fits.header.Standard;
import nom.tam.fits.utilities.FitsHeaderCardParser;
import nom.tam.fits.utilities.FitsLineAppender;
import nom.tam.fits.utilities.FitsSubString;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.CursorValue;

public class HeaderCard
implements CursorValue<String> {
    private static final Logger LOG = Logger.getLogger(HeaderCard.class.getName());
    private static final String CONTINUE_CARD_PREFIX = NonStandard.CONTINUE.key() + "  '";
    public static final int FITS_HEADER_CARD_SIZE = 80;
    private static final String HIERARCH_WITH_BLANK = NonStandard.HIERARCH.key() + " ";
    private static final int HIERARCH_WITH_BLANK_LENGTH = HIERARCH_WITH_BLANK.length();
    private static final String HIERARCH_WITH_DOT = NonStandard.HIERARCH.key() + ".";
    private static final Pattern IEEE_REGEX = Pattern.compile("[+-]?(?=\\d*[.eE])(?=\\.?\\d)\\d*\\.?\\d*(?:[eE][+-]?\\d+)?");
    private static final BigDecimal LONG_MAX_VALUE_AS_BIG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final Pattern LONG_REGEX = Pattern.compile("[+-]?[0-9][0-9]*");
    private static final int MAX_DOUBLE_STRING_LENGTH = 20;
    private static final int MAX_INTEGER_STRING_SIZE = Integer.toString(Integer.MAX_VALUE).length() - 1;
    public static final int MAX_KEYWORD_LENGTH = 8;
    public static final int MAX_LONG_STRING_CONTINUE_OVERHEAD = 3;
    private static final int MAX_LONG_STRING_SIZE = Long.toString(Long.MAX_VALUE).length() - 1;
    public static final int MAX_LONG_STRING_VALUE_LENGTH = 67;
    public static final int MAX_LONG_STRING_VALUE_WITH_COMMENT_LENGTH = 65;
    public static final int MAX_STRING_VALUE_LENGTH = 68;
    public static final int MAX_VALUE_LENGTH = 70;
    private static final int NORMAL_ALIGN_POSITION = 30;
    private static final int NORMAL_SMALL_STRING_ALIGN_POSITION = 19;
    private static final int STRING_SPLIT_POSITION_FOR_EXTRA_COMMENT_SPACE = 35;
    private String comment;
    private boolean isString;
    private String key;
    private boolean nullable;
    private String value;

    public static HeaderCard create(String card) {
        try {
            return new HeaderCard(HeaderCard.stringToArrayInputStream(card));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("card not legal", e);
        }
    }

    private static String dblString(BigDecimal input) {
        String value = input.toString();
        BigDecimal decimal = input;
        while (value.length() > 20) {
            decimal = input.setScale(decimal.scale() - 1, 4);
            value = decimal.toString();
        }
        return value;
    }

    private static String dblString(double input) {
        String value = Double.toString(input);
        if (value.length() > 20) {
            return HeaderCard.dblString(BigDecimal.valueOf(input));
        }
        return value;
    }

    private static ArrayDataInput stringToArrayInputStream(String card) {
        byte[] bytes = AsciiFuncs.getBytes(card);
        if (bytes.length % 80 != 0) {
            byte[] newBytes = new byte[bytes.length + 80 - bytes.length % 80];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            Arrays.fill(newBytes, bytes.length, newBytes.length, (byte)32);
            bytes = newBytes;
        }
        return new BufferedDataInputStream(new ByteArrayInputStream(bytes));
    }

    public HeaderCard(ArrayDataInput dis) throws TruncatedFileException, IOException {
        this(new HeaderCardCountingArrayDataInput(dis));
    }

    public HeaderCard(HeaderCardCountingArrayDataInput dis) throws TruncatedFileException, IOException {
        this.key = null;
        this.value = null;
        this.comment = null;
        this.isString = false;
        String card = HeaderCard.readOneHeaderLine(dis);
        if (FitsFactory.getUseHierarch() && card.length() > HIERARCH_WITH_BLANK_LENGTH && card.startsWith(HIERARCH_WITH_BLANK)) {
            this.hierarchCard(card, dis);
            return;
        }
        if (card.length() < HIERARCH_WITH_BLANK_LENGTH) {
            this.key = card;
            return;
        }
        this.key = card.substring(0, 8).trim();
        if (this.key.length() == 0) {
            this.key = "";
            this.comment = card.substring(8);
            return;
        }
        if (this.key.equals(Standard.COMMENT.key()) || this.key.equals(Standard.HISTORY.key()) || !card.startsWith("= ", 8)) {
            this.comment = card.substring(8).trim();
            return;
        }
        this.extractValueCommentFromString(dis, card);
    }

    public HeaderCard(String key, BigDecimal value, String comment) throws HeaderCardException {
        this(key, HeaderCard.dblString(value), comment, false, false);
    }

    public HeaderCard(String key, BigInteger value, String comment) throws HeaderCardException {
        this(key, HeaderCard.dblString(new BigDecimal(value)), comment, false, false);
    }

    public HeaderCard(String key, boolean value, String comment) throws HeaderCardException {
        this(key, value ? "T" : "F", comment, false, false);
    }

    public HeaderCard(String key, double value, String comment) throws HeaderCardException {
        this(key, HeaderCard.dblString(value), comment, false, false);
    }

    public HeaderCard(String key, float value, String comment) throws HeaderCardException {
        this(key, HeaderCard.dblString(value), comment, false, false);
    }

    public HeaderCard(String key, int value, String comment) throws HeaderCardException {
        this(key, String.valueOf(value), comment, false, false);
    }

    public HeaderCard(String key, long value, String comment) throws HeaderCardException {
        this(key, String.valueOf(value), comment, false, false);
    }

    public HeaderCard(String key, String comment, boolean nullable) throws HeaderCardException {
        this(key, null, comment, nullable, true);
    }

    public HeaderCard(String key, String value, String comment) throws HeaderCardException {
        this(key, value, comment, false, true);
    }

    public HeaderCard(String key, String value, String comment, boolean nullable) throws HeaderCardException {
        this(key, value, comment, nullable, true);
    }

    private HeaderCard(String key, String value, String comment, boolean nullable, boolean isString) throws HeaderCardException {
        this.isString = isString;
        if (key == null && value != null) {
            throw new HeaderCardException("Null keyword with non-null value");
        }
        if (!(key == null || key.length() <= 8 || FitsFactory.getUseHierarch() && key.startsWith(HIERARCH_WITH_DOT))) {
            throw new HeaderCardException("Keyword too long");
        }
        if (value != null) {
            if ((value = value.replaceAll(" *$", "")).startsWith("'")) {
                if (value.charAt(value.length() - 1) != '\'') {
                    throw new HeaderCardException("Missing end quote in string value");
                }
                value = value.substring(1, value.length() - 1).trim();
            }
            if (!FitsFactory.isLongStringsEnabled() && value.replace("'", "''").length() > (this.isString ? 68 : 70)) {
                throw new HeaderCardException("Value too long");
            }
        }
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.nullable = nullable;
    }

    public int cardSize() {
        if (this.isString && this.value != null && FitsFactory.isLongStringsEnabled()) {
            int maxStringValueLength = this.maxStringValueLength();
            String stringValue = this.value.replace("'", "''");
            if (stringValue.length() > maxStringValueLength) {
                return this.toString().length() / 80;
            }
        }
        return 1;
    }

    public HeaderCard copy() throws HeaderCardException {
        HeaderCard copy = new HeaderCard(this.key, null, this.comment, this.nullable, this.isString);
        copy.value = this.value;
        return copy;
    }

    private void extractValueCommentFromString(HeaderCardCountingArrayDataInput dis, String card) throws IOException, TruncatedFileException {
        FitsHeaderCardParser.ParsedValue parsedValue = FitsHeaderCardParser.parseCardValue(card);
        if (FitsFactory.isLongStringsEnabled() && parsedValue.isString() && parsedValue.getValue().endsWith("&")) {
            this.longStringCard(dis, parsedValue);
        } else {
            this.value = parsedValue.getValue();
            this.isString = parsedValue.isString();
            this.comment = parsedValue.getComment();
            if (!this.isString && this.value.indexOf(39) >= 0) {
                throw new IllegalArgumentException("no single quotes allowed in values");
            }
        }
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> clazz, T defaultValue) {
        BigDecimal parsedValue;
        if (String.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.value);
        }
        if (this.value == null || this.value.isEmpty()) {
            return defaultValue;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getBooleanValue((Boolean)defaultValue));
        }
        try {
            parsedValue = new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return clazz.cast(parsedValue.intValueExact());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return clazz.cast(parsedValue.longValueExact());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return clazz.cast(parsedValue.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return clazz.cast(Float.valueOf(parsedValue.floatValue()));
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return clazz.cast(parsedValue);
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return clazz.cast(parsedValue.toBigIntegerExact());
        }
        throw new IllegalArgumentException("unsupported class " + clazz);
    }

    private Boolean getBooleanValue(Boolean defaultValue) {
        if ("T".equals(this.value)) {
            return Boolean.TRUE;
        }
        if ("F".equals(this.value)) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    private void hierarchCard(String card, HeaderCardCountingArrayDataInput dis) throws IOException, TruncatedFileException {
        this.key = FitsHeaderCardParser.parseCardKey(card);
        this.extractValueCommentFromString(dis, card);
    }

    public boolean isKeyValuePair() {
        return this.key != null && this.value != null;
    }

    public boolean isStringValue() {
        return this.isString;
    }

    private void longStringCard(HeaderCardCountingArrayDataInput dis, FitsHeaderCardParser.ParsedValue parsedValue) throws IOException, TruncatedFileException {
        StringBuilder longValue = new StringBuilder();
        StringBuilder longComment = new StringBuilder();
        FitsHeaderCardParser.ParsedValue continueCard = parsedValue;
        do {
            if (continueCard.getValue() != null) {
                longValue.append(continueCard.getValue());
            }
            if (continueCard.getComment() != null) {
                if (longComment.length() != 0) {
                    longComment.append(' ');
                }
                longComment.append(continueCard.getComment());
            }
            continueCard = null;
            if (longValue.length() <= 0 || longValue.charAt(longValue.length() - 1) != '&') continue;
            longValue.setLength(longValue.length() - 1);
            dis.mark();
            String card = HeaderCard.readOneHeaderLine(dis);
            if (card.startsWith(NonStandard.CONTINUE.key())) {
                continueCard = FitsHeaderCardParser.parseCardValue(card);
                continue;
            }
            longValue.append('&');
            dis.reset();
        } while (continueCard != null);
        this.comment = longComment.toString();
        this.value = longValue.toString();
        this.isString = true;
    }

    private int maxStringValueLength() {
        int maxStringValueLength = 68;
        if (FitsFactory.getUseHierarch() && this.getKey().length() > 8) {
            maxStringValueLength -= this.getKey().length() - 8;
        }
        return maxStringValueLength;
    }

    private static String readOneHeaderLine(HeaderCardCountingArrayDataInput dis) throws IOException, TruncatedFileException {
        int need;
        byte[] buffer = new byte[80];
        try {
            int len;
            for (need = 80; need > 0; need -= len) {
                len = dis.in().read(buffer, 80 - need, need);
                if (len != 0) continue;
                throw new TruncatedFileException("nothing to read left");
            }
        }
        catch (EOFException e) {
            if (need == 80) {
                throw e;
            }
            throw new TruncatedFileException(e.getMessage());
        }
        dis.cardRead();
        return AsciiFuncs.asciiString(buffer);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    void setKey(String newKey) {
        this.key = newKey;
    }

    public HeaderCard setValue(boolean update) {
        this.value = update ? "T" : "F";
        return this;
    }

    public HeaderCard setValue(double update) {
        this.value = HeaderCard.dblString(update);
        return this;
    }

    public HeaderCard setValue(float update) {
        this.value = HeaderCard.dblString(update);
        return this;
    }

    public HeaderCard setValue(int update) {
        this.value = String.valueOf(update);
        return this;
    }

    public HeaderCard setValue(long update) {
        this.value = String.valueOf(update);
        return this;
    }

    public HeaderCard setValue(String update) {
        this.value = update;
        return this;
    }

    public String toString() {
        FitsSubString commentSubString;
        int alignSmallString = 19;
        int alignPosition = 30;
        FitsLineAppender buf = new FitsLineAppender();
        if (this.key != null) {
            if (this.key.length() > HIERARCH_WITH_BLANK_LENGTH && this.key.startsWith(HIERARCH_WITH_DOT)) {
                FitsFactory.getHierarchFormater().append(this.key, buf);
                alignSmallString = buf.length();
                alignPosition = buf.length();
            } else {
                buf.append(this.key);
                buf.appendSpacesTo(8);
            }
        }
        if (80 - alignPosition - 3 < (commentSubString = new FitsSubString(this.comment)).length()) {
            alignPosition = Math.max(buf.length(), 77 - commentSubString.length());
            alignSmallString = buf.length();
        }
        boolean commentHandled = false;
        if (this.value != null || this.nullable) {
            buf.append("= ");
            if (this.value != null) {
                if (this.isString) {
                    String stringValue = this.value.replace("'", "''");
                    if (FitsFactory.isLongStringsEnabled() && stringValue.length() > this.maxStringValueLength()) {
                        this.writeLongStringValue(buf, stringValue);
                        commentHandled = true;
                    } else {
                        buf.append('\'');
                        buf.append(stringValue);
                        buf.appendSpacesTo(alignSmallString);
                        buf.append('\'');
                        buf.appendSpacesTo(alignPosition);
                    }
                } else {
                    buf.appendSpacesTo(alignPosition - this.value.length());
                    buf.append(this.value);
                }
            } else {
                buf.appendSpacesTo(alignPosition);
            }
            int spaceLeft = 80 - buf.length();
            int spaceLeftInCard = spaceLeft % 80;
            commentSubString.getAdjustedLength(spaceLeftInCard - 3);
            if (!commentHandled && commentSubString.length() > 0) {
                buf.append(" / ");
            }
        } else if (commentSubString.startsWith("= ")) {
            buf.append("  ");
        }
        if (!commentHandled && commentSubString.length() > 0) {
            if (commentSubString.startsWith(" ")) {
                commentSubString.skip(1);
            }
            buf.append(commentSubString);
        }
        buf.completeLine();
        return buf.toString();
    }

    public Class<?> valueType() {
        if (this.isString) {
            return String.class;
        }
        if (this.value != null) {
            String trimedValue = this.value.trim();
            if ("T".equals(trimedValue) || "F".equals(trimedValue)) {
                return Boolean.class;
            }
            if (LONG_REGEX.matcher(trimedValue).matches()) {
                return HeaderCard.getIntegerNumberType(trimedValue);
            }
            if (IEEE_REGEX.matcher(trimedValue).find()) {
                return HeaderCard.getDecimalNumberType(trimedValue);
            }
        }
        return null;
    }

    private static Class<?> getDecimalNumberType(String value) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("could not parse " + value + " cause:" + e.getCause());
        }
        if (bigDecimal.abs().compareTo(LONG_MAX_VALUE_AS_BIG_DECIMAL) > 0 && bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
            return BigInteger.class;
        }
        if (bigDecimal.doubleValue() == Double.valueOf(value).doubleValue()) {
            return Double.class;
        }
        return BigDecimal.class;
    }

    private static Class<?> getIntegerNumberType(String value) {
        int length = value.length();
        if (value.charAt(0) == '-' || value.charAt(0) == '+') {
            --length;
        }
        if (length <= MAX_INTEGER_STRING_SIZE) {
            return Integer.class;
        }
        if (length <= MAX_LONG_STRING_SIZE) {
            return Long.class;
        }
        return BigInteger.class;
    }

    private void writeLongStringValue(FitsLineAppender buf, String stringValueString) {
        FitsSubString stringValue = new FitsSubString(stringValueString);
        FitsSubString commentValue = new FitsSubString(this.comment);
        stringValue.getAdjustedLength(80 - buf.length() - 3);
        buf.append('\'');
        buf.append(stringValue);
        buf.append("&'");
        buf.completeLine();
        stringValue.rest();
        if (commentValue.startsWith(" ")) {
            commentValue.skip(1);
        }
        while (stringValue.length() > 0) {
            stringValue.getAdjustedLength(67);
            if (stringValue.fullLength() > 67) {
                buf.append(CONTINUE_CARD_PREFIX);
                buf.append(stringValue);
                buf.append("&'");
                stringValue.rest();
                continue;
            }
            if (commentValue.length() > 65 - stringValue.length()) {
                stringValue.getAdjustedLength(35);
                if (stringValue.fullLength() > stringValue.length()) {
                    buf.append(CONTINUE_CARD_PREFIX);
                    buf.append(stringValue);
                    buf.append("&'");
                } else {
                    buf.append(CONTINUE_CARD_PREFIX);
                    buf.append(stringValue);
                    buf.append("'");
                }
                int spaceForComment = buf.spaceLeftInLine() - 3;
                commentValue.getAdjustedLength(spaceForComment);
            } else {
                buf.append(CONTINUE_CARD_PREFIX);
                buf.append(stringValue);
                buf.append('\'');
            }
            if (commentValue.length() > 0) {
                buf.append(" / ");
                buf.append(commentValue);
                commentValue.rest();
            }
            buf.completeLine();
            stringValue.rest();
        }
    }

    protected static HeaderCard saveNewHeaderCard(String key, String comment, boolean isString) {
        try {
            return new HeaderCard(key, null, comment, false, isString);
        }
        catch (HeaderCardException e) {
            LOG.log(Level.SEVERE, "Impossible Exception for internal card creation:" + key, e);
            throw new IllegalStateException(e);
        }
    }
}

