/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider;

public class CompressorControlNameComputer {
    private static final String COMPRESSOR_CLASS_SUFFIX = "Compressor";

    private static String standardizeBaseType(String simpleName) {
        return Character.toUpperCase(simpleName.charAt(0)) + simpleName.substring(1).toLowerCase();
    }

    private static String standardizeCompressionAlgorithm(String compressionAlgorithm) {
        if ("RICE_1".equalsIgnoreCase(compressionAlgorithm) || "RICE_ONE".equalsIgnoreCase(compressionAlgorithm)) {
            return "Rice";
        }
        if ("PLIO_1".equalsIgnoreCase(compressionAlgorithm)) {
            return "PLIO";
        }
        if ("HCOMPRESS_1".equalsIgnoreCase(compressionAlgorithm)) {
            return "H";
        }
        if ("GZIP_2".equalsIgnoreCase(compressionAlgorithm)) {
            return "GZip2";
        }
        if ("GZIP_1".equalsIgnoreCase(compressionAlgorithm)) {
            return "GZip";
        }
        return "Unknown";
    }

    private static String standardizeQuantAlgorithm(String quantAlgorithm) {
        if (quantAlgorithm != null) {
            if ("NO_DITHER".equalsIgnoreCase(quantAlgorithm) || "SUBTRACTIVE_DITHER_1".equalsIgnoreCase(quantAlgorithm) || "SUBTRACTIVE_DITHER_2".equalsIgnoreCase(quantAlgorithm)) {
                return "Quant";
            }
            return "Unknown";
        }
        return "";
    }

    public String createCompressorClassName(String quantAlgorithm, String compressionAlgorithm, Class<?> baseType) {
        StringBuilder className = new StringBuilder();
        className.append(CompressorControlNameComputer.standardizeBaseType(baseType.getSimpleName()));
        if (className.indexOf(Float.class.getSimpleName()) == 0 || className.indexOf(Double.class.getSimpleName()) == 0) {
            quantAlgorithm = null;
        }
        className.append(CompressorControlNameComputer.standardizeQuantAlgorithm(quantAlgorithm));
        className.append(CompressorControlNameComputer.standardizeCompressionAlgorithm(compressionAlgorithm));
        className.append(COMPRESSOR_CLASS_SUFFIX);
        return className.toString();
    }
}

