/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.client.QueryStringBuilder;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.client.call.TokenResponse;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class GetTokenFromCodeCall<T>
extends BaseCall<RapClient<T>> {
    public GetTokenFromCodeCall(RapClient client) {
        super(client);
    }

    public TokenResponse getTokenFromCode(String code, String redirectUri, T context) {
        Map<String, Object> responseMap = this.getTokenFromCodeResponseMap(code, redirectUri, context);
        if (!responseMap.containsKey("id_token")) {
            String accessToken = (String)responseMap.get("access_token");
            Map<String, Object> checkTokenResponseMap = this.getCheckTokenResponseMap(accessToken, context);
            for (Map.Entry<String, Object> entry : checkTokenResponseMap.entrySet()) {
                responseMap.put(entry.getKey(), entry.getValue());
            }
        }
        String compositeMap = GetTokenFromCodeCall.toJson(responseMap);
        return GetTokenFromCodeCall.parseJson(compositeMap, TokenResponse.class);
    }

    private Map<String, Object> getTokenFromCodeResponseMap(String code, String redirectUri, T context) {
        if (code == null) {
            throw new IllegalStateException("Missing code parameter");
        }
        HttpRequest tokenRequest = ((RapClient)this.client).newClientSecretRequest(((RapClient)this.client).getAccessTokenUri(context)).header("Content-Type", "application/x-www-form-urlencoded").POST(this.getAccessTokenBodyPublisher(code, redirectUri)).build();
        return ((RapClient)this.client).call(tokenRequest, HttpResponse.BodyHandlers.ofString(), 200, res -> GetTokenFromCodeCall.parseJson(res, Map.class));
    }

    private HttpRequest.BodyPublisher getAccessTokenBodyPublisher(String code, String redirectUri) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder().param("grant_type", "authorization_code").param("code", code).param("redirect_uri", redirectUri).param("client_id", ((RapClient)this.client).getClientId());
        return HttpRequest.BodyPublishers.ofString(queryStringBuilder.getQueryString());
    }

    private Map<String, Object> getCheckTokenResponseMap(String accessToken, T context) {
        HttpRequest tokenRequest = ((RapClient)this.client).newRequest(((RapClient)this.client).getCheckTokenUri(context), context).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Bearer " + accessToken).POST(HttpRequest.BodyPublishers.ofString("client_id=" + ((RapClient)this.client).getClientId())).build();
        return ((RapClient)this.client).call(tokenRequest, HttpResponse.BodyHandlers.ofString(), 200, res -> GetTokenFromCodeCall.parseJson(res, Map.class));
    }
}

