/*
 * Decompiled with CFR 0.152.
 */
package uws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.ClientAbortException;
import uws.UWSException;
import uws.job.ErrorSummary;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.UWSUrl;
import uws.service.UserIdentifier;
import uws.service.log.DefaultUWSLog;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class UWSToolBox {
    public static final String DEFAULT_CHAR_ENCODING = "UTF-8";
    private static UWSLog defaultLogger = null;
    protected static final String[] fileExts = new String[]{"", "vot", "json", "json", "csv", "tsv", "txt", "xml", "xml", "pdf", "ai", "eps", "ps", "html", "zip", "gzip", "gz", "tar", "gif", "jpeg", "jpg", "png", "bmp"};
    protected static final String[] mimeTypes = new String[]{"application/octet-stream", "application/x-votable+xml", "application/json", "text/json", "text/csv", "text/tab-separated-values", "text/plain", "application/xml", "text/xml", "application/pdf", "application/postscript", "application/postscript", "application/postscript", "text/html", "application/zip", "application/x-gzip", "application/x-gzip", "application/x-tar", "image/gif", "image/jpeg", "image/jpeg", "image/png", "image/x-portable-bitmap"};

    private UWSToolBox() {
    }

    public static final URL getServerResource(String serverPath, HttpServletRequest req) {
        if (serverPath == null || req == null) {
            return null;
        }
        try {
            if (serverPath.length() > 0 && serverPath.charAt(0) != '/') {
                serverPath = "/" + serverPath;
            }
            return new URL(req.getRequestURL().substring(0, req.getRequestURL().lastIndexOf(req.getContextPath()) + req.getContextPath().length()) + serverPath);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static final UWSLog getDefaultLogger() {
        if (defaultLogger == null) {
            defaultLogger = new DefaultUWSLog(System.err);
        }
        return defaultLogger;
    }

    public static final Map<String, String> getParamsMap(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (req.getAttribute("UWS_PARAMETERS") != null) {
            try {
                Map params = (Map)req.getAttribute("UWS_PARAMETERS");
                for (Map.Entry e : params.entrySet()) {
                    if (e.getValue() == null) continue;
                    if (e.getValue().getClass().isArray()) {
                        StringBuffer str = new StringBuffer();
                        Object array = e.getValue();
                        int length = Array.getLength(array);
                        for (int i = 0; i < length; ++i) {
                            if (i > 0) {
                                str.append(';');
                            }
                            str.append(Array.get(array, i));
                        }
                        map.put((String)e.getKey(), str.toString());
                        continue;
                    }
                    map.put((String)e.getKey(), e.getValue().toString());
                }
                return map;
            }
            catch (Exception ex) {
                map.clear();
            }
        }
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            int i;
            String n = (String)names.nextElement();
            String[] values = req.getParameterValues(n);
            for (i = values.length - 1; i >= 0 && values[i] == null; --i) {
            }
            if (i < 0) continue;
            map.put(n.toLowerCase(), values[i]);
        }
        return map;
    }

    public static final String getQueryPart(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuffer queryPart = new StringBuffer();
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            if (key != null) {
                key = key.trim().toUpperCase();
            }
            if (val != null) {
                val = val.trim();
            }
            if (key == null || key.isEmpty() || val == null || val.isEmpty()) continue;
            try {
                queryPart.append(URLEncoder.encode(e.getKey(), DEFAULT_CHAR_ENCODING) + "=" + URLEncoder.encode(val, DEFAULT_CHAR_ENCODING));
                queryPart.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return queryPart.substring(0, queryPart.length() - 1);
    }

    public static final Map<String, String> getParameters(String queryPart) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (queryPart != null && !(queryPart = queryPart.substring(queryPart.indexOf("?") + 1).trim()).isEmpty()) {
            String[] keyValues;
            for (String item : keyValues = queryPart.split("&")) {
                String[] keyValue = item.split("=");
                if (keyValue.length != 2) continue;
                keyValue[0] = keyValue[0].trim().toLowerCase();
                keyValue[1] = keyValue[1].trim();
                if (keyValue[0].isEmpty() || keyValue[1].isEmpty()) continue;
                try {
                    parameters.put(URLDecoder.decode(keyValue[0], DEFAULT_CHAR_ENCODING), URLDecoder.decode(keyValue[1], DEFAULT_CHAR_ENCODING));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return parameters;
    }

    public static final Map<String, Object> addGETParameters(HttpServletRequest req, Map<String, Object> parameters) {
        String queryString = req.getQueryString();
        if (queryString != null) {
            String[] params;
            for (String p : params = queryString.split("&")) {
                int indSep = p.indexOf(61);
                if (indSep < 0) continue;
                try {
                    parameters.put(URLDecoder.decode(p.substring(0, indSep), DEFAULT_CHAR_ENCODING), URLDecoder.decode(p.substring(indSep + 1), DEFAULT_CHAR_ENCODING));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return parameters;
    }

    public static final int getNbParameters(HttpServletRequest request) {
        if (request == null) {
            return 0;
        }
        try {
            return ((Map)request.getAttribute("UWS_PARAMETERS")).size();
        }
        catch (Exception ex) {
            return request.getParameterMap().size();
        }
    }

    public static final boolean hasParameter(String name, HttpServletRequest request, boolean caseSensitive) {
        return UWSToolBox.getParameter(name, request, caseSensitive) != null;
    }

    public static final boolean hasParameter(String name, String value, HttpServletRequest request, boolean caseSensitive) {
        Object found = UWSToolBox.getParameter(name, request, caseSensitive);
        if (value == null) {
            return found != null;
        }
        if (found == null || !(found instanceof String)) {
            return false;
        }
        return caseSensitive && ((String)found).equals(value) || !caseSensitive && ((String)found).equalsIgnoreCase(value);
    }

    public static final Object getParameter(String name, HttpServletRequest request, boolean caseSensitive) {
        try {
            Map params = (Map)request.getAttribute("UWS_PARAMETERS");
            for (Map.Entry e : params.entrySet()) {
                if ((caseSensitive || !((String)e.getKey()).equalsIgnoreCase(name)) && (!caseSensitive || !((String)e.getKey()).equals(name))) continue;
                return e.getValue() != null ? e.getValue() : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final int deleteUploads(HttpServletRequest req) {
        int cnt = 0;
        Object attribute = req.getAttribute("UWS_PARAMETERS");
        if (attribute != null && attribute instanceof Map) {
            Map params = (Map)attribute;
            for (Map.Entry e : params.entrySet()) {
                if (e.getValue() == null || !(e.getValue() instanceof UploadFile) || ((UploadFile)e.getValue()).isUsed()) continue;
                try {
                    ((UploadFile)e.getValue()).deleteFile();
                    ++cnt;
                }
                catch (IOException iOException) {}
            }
        }
        return cnt;
    }

    public static final JobOwner getUser(HttpServletRequest request, UserIdentifier userIdentifier) throws NullPointerException, UWSException {
        if (request == null) {
            return null;
        }
        if (request.getAttribute("UWS_USER") != null) {
            return (JobOwner)request.getAttribute("UWS_USER");
        }
        if (userIdentifier != null) {
            JobOwner user = userIdentifier.extractUserId(new UWSUrl(request), request);
            request.setAttribute("UWS_USER", (Object)user);
            return user;
        }
        return null;
    }

    public static final void clearDirectory(String directoryPath) {
        UWSToolBox.clearDirectory(new File(directoryPath));
    }

    public static final void clearDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory() && directory.canWrite()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    public static final void flush(PrintWriter writer) throws ClientAbortException {
        writer.flush();
        if (writer.checkError()) {
            throw new ClientAbortException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(InputStream input, String mimeType, long contentSize, HttpServletResponse response) throws IOException {
        ServletOutputStream output = null;
        try {
            int length;
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            response.setCharacterEncoding(DEFAULT_CHAR_ENCODING);
            UWSToolBox.setContentLength(response, contentSize);
            output = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        finally {
            if (output != null) {
                output.flush();
            }
        }
    }

    public static final boolean writeErrorFile(Exception ex, ErrorSummary error, UWSJob job, OutputStream output) throws IOException {
        if (ex == null) {
            return false;
        }
        PrintWriter pw = new PrintWriter(output);
        pw.println("Date: " + new Date().toString());
        pw.println("Job: " + job.getJobId());
        pw.println("Type: " + (Object)((Object)error.getType()));
        pw.println("Message: " + error.getMessage());
        pw.println("Stack Trace:");
        UWSToolBox.printStackTrace(ex, pw);
        pw.close();
        return true;
    }

    public static final void printStackTrace(Throwable ex, PrintWriter pw) throws IOException {
        pw.println(ex.getClass().getName() + ": " + ex.getMessage());
        StackTraceElement[] elements = ex.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            pw.println("\tat " + elements[i].toString());
        }
        if (ex.getCause() != null) {
            pw.print("Caused by: ");
            pw.flush();
            UWSToolBox.printStackTrace(ex.getCause(), pw);
        }
        pw.flush();
    }

    public static final void printURL(UWSUrl url) {
        try {
            UWSToolBox.printURL(url, System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void printURL(UWSUrl url, OutputStream output) throws IOException {
        StringBuffer toPrint = new StringBuffer();
        toPrint.append("***** UWS_URL (").append(url.getBaseURI()).append(") *****");
        toPrint.append("\nRequest URL: ").append(url.getRequestURL());
        toPrint.append("\nRequest URI: ").append(url.getRequestURI());
        toPrint.append("\nUWS URI: ").append(url.getUwsURI());
        toPrint.append("\nJob List: ").append(url.getJobListName());
        toPrint.append("\nJob ID: ").append(url.getJobId());
        toPrint.append("\nAttributes (").append(url.getAttributes().length).append("):");
        for (String att : url.getAttributes()) {
            toPrint.append(" ").append(att);
        }
        toPrint.append("\n");
        output.write(toPrint.toString().getBytes());
    }

    public static final String getMimeType(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        if ((fileExtension = fileExtension.trim()).length() > 0 && fileExtension.charAt(0) == '.') {
            fileExtension = fileExtension.substring(1).trim();
        }
        for (int i = 0; i < fileExts.length; ++i) {
            if (!fileExtension.equalsIgnoreCase(fileExts[i])) continue;
            return mimeTypes[i];
        }
        return null;
    }

    public static final String getFileExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        mimeType = mimeType.trim();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (!mimeType.equalsIgnoreCase(mimeTypes[i])) continue;
            return fileExts[i];
        }
        return null;
    }

    public static final void setContentLength(HttpServletResponse response, long contentSize) {
        if (response != null && contentSize > 0L) {
            response.setHeader("Content-Length", String.valueOf(contentSize));
        }
    }
}

