/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.ExecutionPhase;
import uws.job.JobList;
import uws.job.JobObserver;
import uws.job.JobPhase;
import uws.job.JobThread;
import uws.job.Result;
import uws.job.SerializableUWSObject;
import uws.job.jobInfo.JobInfo;
import uws.job.jobInfo.SingleValueJobInfo;
import uws.job.manager.ExecutionManager;
import uws.job.parameters.UWSParameters;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;
import uws.service.UWSFactory;
import uws.service.UWSUrl;
import uws.service.file.UWSFileManager;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class UWSJob
extends SerializableUWSObject {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_ACTION = "ACTION";
    public static final String ACTION_DELETE = "DELETE";
    public static final String PARAM_JOB_ID = "jobId";
    public static final String PARAM_CREATION_TIME = "creationTime";
    public static final String PARAM_RUN_ID = "runId";
    public static final String PARAM_OWNER = "owner";
    public static final String PARAM_PHASE = "phase";
    public static final String PHASE_RUN = "RUN";
    public static final String PHASE_ABORT = "ABORT";
    public static final String PARAM_QUOTE = "quote";
    public static final String PARAM_START_TIME = "startTime";
    public static final String PARAM_END_TIME = "endTime";
    public static final String PARAM_EXECUTION_DURATION = "executionDuration";
    public static final String PARAM_DESTRUCTION_TIME = "destruction";
    public static final String PARAM_ERROR_SUMMARY = "error";
    public static final String PARAM_PARAMETERS = "parameters";
    public static final String PARAM_RESULTS = "results";
    public static final String PARAM_JOB_INFO = "jobInfo";
    public static final String ANONYMOUS_OWNER = "anonymous";
    @Deprecated
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final long QUOTE_NOT_KNOWN = -1L;
    public static final long UNLIMITED_DURATION = 0L;
    protected static String lastId = System.currentTimeMillis() + "A";
    protected final String jobId;
    protected final Date creationTime;
    protected final JobOwner owner;
    private JobList myJobList = null;
    private JobPhase phase;
    @Deprecated
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private long quote = -1L;
    private Date startTime = null;
    private Date endTime = null;
    protected ErrorSummary errorSummary = null;
    protected Map<String, Result> results;
    protected final UWSParameters inputParams;
    protected JobInfo jobInfo = null;
    protected transient JobThread thread = null;
    protected long waitForStop = 1000L;
    private Vector<JobObserver> observers = new Vector();
    private final Date restorationDate;
    protected boolean stopping = false;

    public UWSJob(UWSParameters params) {
        this(null, params);
    }

    public UWSJob(JobOwner owner, UWSParameters params) {
        this.creationTime = new Date();
        this.owner = owner;
        this.phase = new JobPhase(this);
        this.results = new HashMap<String, Result>();
        this.inputParams = params == null ? new UWSParameters() : params;
        this.inputParams.init();
        this.jobId = this.generateJobId();
        this.restorationDate = null;
        Iterator<UploadFile> files = this.inputParams.getFiles();
        while (files.hasNext()) {
            try {
                files.next().move(this);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UWSJob(JobOwner owner, UWSParameters params, String requestID) {
        this.creationTime = new Date();
        this.owner = owner;
        this.phase = new JobPhase(this);
        this.results = new HashMap<String, Result>();
        this.inputParams = params == null ? new UWSParameters() : params;
        this.inputParams.init();
        String string = lastId;
        synchronized (string) {
            if (requestID == null || requestID.trim().length() == 0 || lastId.equals(requestID)) {
                this.jobId = this.generateJobId();
            } else {
                this.jobId = requestID;
                lastId = requestID;
            }
        }
        this.restorationDate = null;
        Iterator<UploadFile> files = this.inputParams.getFiles();
        while (files.hasNext()) {
            try {
                files.next().move(this);
            }
            catch (IOException iOException) {}
        }
    }

    public UWSJob(String jobID, long creationTime, JobOwner owner, UWSParameters params, long quote, long startTime, long endTime, List<Result> results, ErrorSummary error) throws NullPointerException {
        if (jobID == null) {
            throw new NullPointerException("Missing job ID => impossible to build a Job without a valid ID!");
        }
        this.creationTime = creationTime <= 0L ? new Date() : new Date(creationTime);
        this.jobId = jobID;
        this.owner = owner;
        this.quote = quote;
        if (startTime > 0L) {
            this.startTime = new Date(startTime);
        }
        if (endTime > 0L) {
            this.endTime = new Date(endTime);
        }
        this.results = new HashMap<String, Result>();
        if (results != null) {
            for (Result r : results) {
                if (r == null) continue;
                this.results.put(r.getId(), r);
            }
        }
        this.errorSummary = error;
        this.phase = new JobPhase(this);
        this.inputParams = params;
        params.init();
        ExecutionPhase p = ExecutionPhase.PENDING;
        if (startTime > 0L && endTime > 0L) {
            if (this.results.isEmpty() && this.errorSummary == null) {
                p = ExecutionPhase.ABORTED;
            } else if (!this.results.isEmpty()) {
                p = ExecutionPhase.COMPLETED;
            } else if (this.errorSummary != null) {
                p = ExecutionPhase.ERROR;
            }
        }
        if (this.phase != null) {
            try {
                this.setPhase(p, true);
            }
            catch (UWSException uWSException) {
                // empty catch block
            }
        }
        this.restorationDate = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateJobId() {
        String string = lastId;
        synchronized (string) {
            String generatedId = System.currentTimeMillis() + "A";
            if (lastId != null) {
                while (lastId.equals(generatedId)) {
                    generatedId = generatedId.substring(0, generatedId.length() - 1) + (char)(generatedId.charAt(generatedId.length() - 1) + '\u0001');
                }
            }
            lastId = generatedId;
            return generatedId;
        }
    }

    public Object getParameter(String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        if ((name = name.trim()).equalsIgnoreCase(PARAM_JOB_ID)) {
            return this.jobId;
        }
        if (name.equalsIgnoreCase(PARAM_CREATION_TIME)) {
            return this.creationTime;
        }
        if (name.equalsIgnoreCase(PARAM_OWNER)) {
            return this.owner;
        }
        if (name.equalsIgnoreCase(PARAM_PHASE)) {
            return this.phase.getPhase();
        }
        if (name.equalsIgnoreCase(PARAM_QUOTE)) {
            return this.quote;
        }
        if (name.equalsIgnoreCase(PARAM_START_TIME)) {
            return this.startTime;
        }
        if (name.equalsIgnoreCase(PARAM_END_TIME)) {
            return this.endTime;
        }
        return this.inputParams.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPhaseParam(JobOwner user) throws UWSException {
        UWSParameters uWSParameters = this.inputParams;
        synchronized (uWSParameters) {
            if (this.inputParams.hasInputPhase()) {
                String inputPhase = this.inputParams.getInputPhase();
                if (inputPhase.equalsIgnoreCase(PHASE_RUN)) {
                    if (user != null && !user.equals(this.owner) && !user.hasExecutePermission(this)) {
                        throw new UWSException(550, UWSExceptionFactory.executePermissionDenied(user, this.jobId));
                    }
                    this.start();
                } else if (inputPhase.equalsIgnoreCase(PHASE_ABORT)) {
                    if (user != null && !user.equals(this.owner) && !user.hasExecutePermission(this)) {
                        throw new UWSException(550, UWSExceptionFactory.executePermissionDenied(user, this.jobId));
                    }
                    this.abort();
                }
            }
        }
    }

    public final UWSFileManager getFileManager() {
        if (this.myJobList != null && this.myJobList.getUWS() != null) {
            return this.myJobList.getUWS().getFileManager();
        }
        return null;
    }

    public UWSLog getLogger() {
        if (this.myJobList != null && this.myJobList.getUWS() != null) {
            return this.myJobList.getUWS().getLogger();
        }
        return UWSToolBox.getDefaultLogger();
    }

    public final UWSFactory getFactory() {
        if (this.myJobList != null && this.myJobList.getUWS() != null) {
            return this.myJobList.getUWS().getFactory();
        }
        return null;
    }

    public final Date getRestorationDate() {
        return this.restorationDate;
    }

    public final ExecutionPhase getPhase() {
        return this.phase.getPhase();
    }

    public final void setPhase(ExecutionPhase p) throws UWSException {
        this.setPhase(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPhase(ExecutionPhase p, boolean force) throws UWSException {
        JobPhase jobPhase = this.phase;
        synchronized (jobPhase) {
            ExecutionPhase oldPhase = this.phase.getPhase();
            this.phase.setPhase(p, force);
            if (!force) {
                this.getLogger().logJob(UWSLog.LogLevel.INFO, this, "CHANGE_PHASE", "The job \"" + this.getJobId() + "\" goes from " + (Object)((Object)oldPhase) + " to " + (Object)((Object)p), null);
            }
            if (this.phase.isFinished() && this.getJobList() != null) {
                this.getJobList().getExecutionManager().remove(this);
            }
            this.notifyObservers(oldPhase);
        }
    }

    public final JobPhase getPhaseManager() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPhaseManager(JobPhase jobPhase) {
        if (jobPhase != null) {
            JobPhase jobPhase2 = this.phase;
            synchronized (jobPhase2) {
                this.phase = jobPhase;
            }
        }
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(Date newDateTime) {
        this.startTime = newDateTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    protected final void setEndTime(Date newDateTime) {
        this.endTime = newDateTime;
        if (this.phase.isFinished() && this.owner != null && this.getJobList() != null && this.getJobList().getUWS() != null && this.getJobList().getUWS().getBackupManager() != null) {
            this.getJobList().getUWS().getBackupManager().saveOwner(this.owner);
        }
        this.getLogger().logJob(UWSLog.LogLevel.INFO, this, "END", "Job \"" + this.jobId + "\" ended with the status " + this.phase, null);
    }

    public final long getExecutionDuration() {
        return this.inputParams.getExecutionDuration();
    }

    public final void setExecutionDuration(long executionDuration) {
        if (this.phase.isJobUpdatable()) {
            try {
                this.inputParams.set(PARAM_EXECUTION_DURATION, executionDuration);
            }
            catch (UWSException uWSException) {
                // empty catch block
            }
        }
    }

    public final Date getDestructionTime() {
        return this.inputParams.getDestructionTime();
    }

    public final void setDestructionTime(Date destructionTime) {
        if (destructionTime != null && this.phase.isJobUpdatable()) {
            try {
                this.inputParams.set(PARAM_DESTRUCTION_TIME, destructionTime);
                if (this.myJobList != null) {
                    this.myJobList.updateDestruction(this);
                }
            }
            catch (UWSException ue) {
                this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "SET_DESTRUCTION", "Can not set the destruction time of the job \"" + this.getJobId() + "\" to \"" + destructionTime + "\"!", ue);
            }
        }
    }

    public final ErrorSummary getErrorSummary() {
        return this.errorSummary;
    }

    public final void setErrorSummary(ErrorSummary errorSummary) throws UWSException {
        if (errorSummary == null) {
            return;
        }
        if (this.isFinished()) {
            this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "SET_ERROR", "Can not set an error summary when the job is finished (or not yet started)! The current phase is: " + (Object)((Object)this.getPhase()) + " ; the summary of the error to set is: \"" + errorSummary.message + "\".", null);
            throw new UWSException(405, UWSExceptionFactory.jobModificationForbidden(this.jobId, this.getPhase(), "ERROR SUMMARY"));
        }
        this.errorSummary = errorSummary;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final String getRunId() {
        return this.inputParams.getRunId();
    }

    public final void setRunId(String name) {
        if (!this.phase.isFinished()) {
            try {
                this.inputParams.set(PARAM_RUN_ID, name);
            }
            catch (UWSException uWSException) {
                // empty catch block
            }
        }
    }

    public final JobOwner getOwner() {
        return this.owner;
    }

    public final long getQuote() {
        return this.quote;
    }

    public final void setQuote(long nbSeconds) {
        if (!this.phase.isFinished()) {
            this.quote = nbSeconds;
        }
    }

    public final Set<String> getAdditionalParameters() {
        return this.inputParams.getAdditionalParameters().keySet();
    }

    public final int getNbAdditionalParameters() {
        return this.inputParams.getAdditionalParameters().size();
    }

    public final Object getAdditionalParameterValue(String paramName) {
        return this.inputParams.getAdditionalParameters().get(paramName);
    }

    public final boolean addOrUpdateParameter(String paramName, Object paramValue) throws UWSException {
        return this.addOrUpdateParameter(paramName, paramValue, null);
    }

    public final boolean addOrUpdateParameter(String paramName, Object paramValue, JobOwner user) throws UWSException {
        if (paramValue != null && !this.phase.isFinished()) {
            this.inputParams.set(paramName, paramValue);
            if (paramValue.equals(PARAM_DESTRUCTION_TIME)) {
                if (this.myJobList != null) {
                    this.myJobList.updateDestruction(this);
                }
            } else if (paramValue != null && paramValue instanceof UploadFile) {
                try {
                    ((UploadFile)paramValue).move(this);
                }
                catch (IOException ioe) {
                    this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "MOVE_UPLOAD", "Can not move an uploaded file in the job \"" + this.jobId + "\"!", ioe);
                    this.inputParams.remove(paramName);
                }
            }
            this.applyPhaseParam(user);
            return true;
        }
        return false;
    }

    public boolean addOrUpdateParameters(UWSParameters params) throws UWSException {
        return this.addOrUpdateParameters(params, null);
    }

    public final Date getCreationTime() {
        return this.creationTime;
    }

    public boolean addOrUpdateParameters(UWSParameters params, JobOwner user) throws UWSException {
        String[] updated;
        if (!this.phase.isJobUpdatable()) {
            throw new UWSException(403, "Forbidden parameters modification: the job is not any more in the PENDING phase!");
        }
        if (user != null && !user.equals(this.owner) && !user.hasWritePermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, false, this.getJobId()));
        }
        for (String updatedParam : updated = this.inputParams.update(params)) {
            if (updatedParam.equals(PARAM_DESTRUCTION_TIME)) {
                if (this.myJobList == null) continue;
                this.myJobList.updateDestruction(this);
                continue;
            }
            Object newValue = this.inputParams.get(updatedParam);
            if (newValue == null || !(newValue instanceof UploadFile)) continue;
            try {
                ((UploadFile)newValue).move(this);
            }
            catch (IOException ioe) {
                this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "MOVE_UPLOAD", "Can not move an uploaded file in the job \"" + this.jobId + "\"!", ioe);
                this.inputParams.remove(updatedParam);
            }
        }
        this.applyPhaseParam(user);
        return updated.length == params.size();
    }

    public final boolean removeAdditionalParameter(String paramName) {
        if (this.phase.isFinished() || paramName == null) {
            return false;
        }
        Object removed = this.inputParams.remove(paramName);
        if (removed != null && removed instanceof UploadFile) {
            try {
                ((UploadFile)removed).deleteFile();
            }
            catch (IOException ioe) {
                this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "MOVE_UPLOAD", "Can not delete the uploaded file \"" + paramName + "\" of the job \"" + this.jobId + "\"!", ioe);
            }
        }
        return true;
    }

    public final Iterator<Result> getResults() {
        return this.results.values().iterator();
    }

    public final Result getResult(String resultId) {
        return this.results.get(resultId);
    }

    public final int getNbResults() {
        return this.results.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addResult(Result res) throws UWSException {
        if (res == null) {
            return false;
        }
        if (this.isFinished()) {
            UWSException ue = new UWSException(405, UWSExceptionFactory.jobModificationForbidden(this.getJobId(), this.getPhase(), "RESULT"));
            this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "ADD_RESULT", "Can not add the result \"" + res.getId() + "\" to the job \"" + this.getJobId() + "\": this job is already finished (or not yet started). Current phase: " + (Object)((Object)this.getPhase()), ue);
            throw ue;
        }
        Map<String, Result> map = this.results;
        synchronized (map) {
            if (this.results.containsKey(res.getId())) {
                return false;
            }
            this.results.put(res.getId(), res);
            return true;
        }
    }

    public final JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setJobInfo(JobInfo newJobInfo) {
        if (this.jobInfo != null) {
            this.jobInfo.setJob(null);
        }
        if (newJobInfo != null) {
            newJobInfo.setJob(this);
        }
        this.jobInfo = newJobInfo;
    }

    public final ExecutionManager getExecutionManager() {
        return this.getJobList().getExecutionManager();
    }

    public final JobList getJobList() {
        return this.myJobList;
    }

    protected final void setJobList(JobList jobList) throws IllegalStateException {
        if (jobList == null) {
            return;
        }
        if (this.myJobList != null && jobList.equals(this.myJobList)) {
            return;
        }
        if (this.myJobList == null || this.phase.getPhase() == ExecutionPhase.PENDING) {
            if (this.myJobList != null && this.myJobList.getJob(this.jobId) != null) {
                this.myJobList.removeJob(this.jobId);
            }
        } else {
            throw new IllegalStateException("Impossible to move a job (here: " + this.jobId + ") from a jobs list (here: " + (this.myJobList == null ? "null" : this.myJobList.getName()) + ") to another (here: " + (jobList == null ? "null" : jobList.getName()) + ") if the job is not PENDING !");
        }
        this.myJobList = jobList;
    }

    public final UWSUrl getUrl() {
        UWSUrl url;
        if (this.myJobList != null && (url = this.myJobList.getUrl()) != null) {
            return url.jobSummary(this.myJobList.getName(), this.jobId);
        }
        return null;
    }

    public final long getTimeToWaitForEnd() {
        return this.waitForStop;
    }

    public final void setTimeToWaitForEnd(long timeToWait) {
        this.waitForStop = timeToWait;
    }

    public final void start() throws UWSException {
        this.start(this.getJobList() != null);
    }

    public void start(boolean useManager) throws UWSException {
        if (this.myJobList == null || this.myJobList.getUWS() == null) {
            throw new IllegalStateException("A UWSJob can not start if it is not linked to a job list or if its job list is not linked to a UWS.");
        }
        if (this.isRunning()) {
            return;
        }
        if (useManager) {
            this.getJobList().getExecutionManager().execute(this);
        } else {
            this.thread = this.getFactory().createJobThread(this);
            if (this.thread == null) {
                throw new NullPointerException("Missing job work! The thread created by the factory is NULL => The job can't be executed!");
            }
            this.setPhase(ExecutionPhase.QUEUED);
            this.setPhase(ExecutionPhase.EXECUTING);
            this.setStartTime(new Date());
            this.thread.start();
            new JobTimeOut().start();
            this.getLogger().logJob(UWSLog.LogLevel.INFO, this, "START", "Job \"" + this.jobId + "\" started.", null);
        }
    }

    public final boolean isRunning() {
        return this.phase.isExecuting() && !this.isStopped();
    }

    public final boolean isFinished() {
        return this.phase.isFinished() && this.isStopped();
    }

    public void abort() throws UWSException {
        this.stop();
        if (this.isStopped()) {
            if (!this.phase.isFinished()) {
                this.setPhase(ExecutionPhase.ABORTED);
                this.setEndTime(new Date());
            } else if ((this.thread == null || this.thread != null && !this.thread.isAlive()) && this.phase.getPhase() != ExecutionPhase.ABORTED) {
                throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.getJobId(), this.phase.getPhase(), ExecutionPhase.ABORTED));
            }
        } else {
            this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, PHASE_ABORT, "Abortion of the job \"" + this.getJobId() + "\" asked but not yet effective (after having waited " + this.waitForStop + "ms)!", null);
        }
    }

    public void error(ErrorSummary error) throws UWSException {
        this.stop();
        if (this.isStopped()) {
            if (!this.phase.isFinished()) {
                this.setErrorSummary(error);
                this.setPhase(ExecutionPhase.ERROR);
                this.setEndTime(new Date());
            } else if (this.thread != null && !this.thread.isAlive()) {
                throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.jobId, this.phase.getPhase(), ExecutionPhase.ERROR));
            }
        } else {
            this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "ERROR", "Stopping of the job \"" + this.getJobId() + "\" with error asked but not yet effective (after having waited " + this.waitForStop + "ms)!", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        if (!this.isStopped()) {
            JobThread jobThread = this.thread;
            synchronized (jobThread) {
                this.stopping = true;
                this.thread.interrupt();
                if (this.waitForStop > 0L) {
                    try {
                        this.thread.join(this.waitForStop);
                    }
                    catch (InterruptedException ie) {
                        this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "END", "Unexpected InterruptedException while waiting for the end of the execution of the job \"" + this.jobId + "\" (thread ID: " + this.thread.getId() + ")!", ie);
                    }
                }
            }
        }
    }

    protected final boolean isStopped() {
        return this.thread == null || !this.thread.isAlive() || this.thread.isFinished();
    }

    public boolean archive() {
        this.clearResources(false);
        if (this.getJobList() != null && this.getJobList().getDestructionManager() != null) {
            this.getJobList().getDestructionManager().remove(this);
        }
        try {
            if (this.getJobInfo() == null) {
                this.setJobInfo(new SingleValueJobInfo("oldPhase", this.getPhase().toString()));
            }
            this.setPhase(ExecutionPhase.ARCHIVED);
            this.getLogger().logJob(UWSLog.LogLevel.INFO, this, "ARCHIVE", "Job successfully archived!", null);
            return true;
        }
        catch (UWSException ue) {
            this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "ARCHIVE", "Impossible to change the phase of this job into ARCHIVED!", ue);
            return false;
        }
    }

    public void clearResources() {
        this.clearResources(true);
    }

    public void clearResources(boolean fullClean) {
        if (!this.phase.isFinished()) {
            try {
                this.abort();
            }
            catch (UWSException e) {
                this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "CLEAR_RESOURCES", "Impossible to abort the job \"" + this.jobId + "\" => trying to stop it...", e);
                this.stop();
            }
        }
        if (this.getJobList() != null) {
            this.getJobList().getExecutionManager().remove(this);
        }
        this.thread = null;
        Iterator<UploadFile> files = this.inputParams.getFiles();
        while (files.hasNext()) {
            UploadFile upl = files.next();
            try {
                upl.deleteFile();
                files.remove();
            }
            catch (IOException ioe) {
                this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "CLEAR_RESOURCES", "Impossible to delete the file uploaded as parameter \"" + upl.paramName + "\" (" + upl.getLocation() + ") of the job \"" + this.jobId + "\"!", null);
            }
        }
        Iterator<Result> itResults = this.getResults();
        while (itResults.hasNext()) {
            Result r = itResults.next();
            try {
                this.getFileManager().deleteResult(r, this);
                itResults.remove();
            }
            catch (IOException ioe) {
                this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "CLEAR_RESOURCES", "Impossible to delete the file associated with the result '" + r.getId() + "' of the job \"" + this.jobId + "\"!", ioe);
            }
        }
        if (fullClean) {
            if (this.errorSummary != null && this.errorSummary.hasDetail()) {
                try {
                    this.getFileManager().deleteError(this.errorSummary, this);
                    this.errorSummary = null;
                }
                catch (IOException ioe) {
                    this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "CLEAR_RESOURCES", "Impossible to delete the file associated with the error '" + this.errorSummary.message + "' of the job \"" + this.jobId + "\"!", ioe);
                }
            }
            if (this.jobInfo != null) {
                try {
                    this.jobInfo.destroy();
                }
                catch (UWSException ue) {
                    this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "CLEAR_RESOURCES", "Impossible to destroy the additional information about the job \"" + this.jobId + "\"", ue);
                }
            }
        }
        this.getLogger().logJob(UWSLog.LogLevel.INFO, this, "CLEAR_RESOURCES", (fullClean ? "All resources" : "Threads and input and result files") + " associated with the job \"" + this.getJobId() + "\" have been successfully freed.", null);
    }

    public final boolean addObserver(JobObserver observer) {
        if (observer != null && !this.observers.contains(observer)) {
            this.observers.add(observer);
            return true;
        }
        return false;
    }

    public final int getNbObservers() {
        return this.observers.size();
    }

    public final Iterator<JobObserver> getObservers() {
        return this.observers.iterator();
    }

    public final boolean removeObserver(JobObserver observer) {
        return this.observers.remove(observer);
    }

    public final void removeAllObservers() {
        this.observers.clear();
    }

    public final void notifyObservers(ExecutionPhase oldPhase) {
        String errors = null;
        for (JobObserver observer : this.observers) {
            try {
                observer.update(this, oldPhase, this.getPhase());
            }
            catch (UWSException ex) {
                if (errors == null) {
                    errors = "\t* " + ex.getMessage();
                    continue;
                }
                errors = errors + "\n\t* " + ex.getMessage();
            }
        }
        if (errors != null) {
            this.getLogger().logJob(UWSLog.LogLevel.WARNING, this, "NOTIFY", "Some observers of the job \"" + this.jobId + "\" can not have been updated:\n" + errors, null);
        }
    }

    public final UWSException getWorkError() {
        return this.thread == null || !this.thread.isAlive() ? null : this.thread.getError();
    }

    @Override
    public String serialize(UWSSerializer serializer, JobOwner user) throws UWSException, Exception {
        if (user != null && !user.equals(this.getOwner()) && !user.hasReadPermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.readPermissionDenied(user, false, this.getJobId()));
        }
        return serializer.getJob(this, true);
    }

    public String serialize(String[] attributes, UWSSerializer serializer) throws Exception {
        return serializer.getJob(this, attributes, true);
    }

    public void serialize(ServletOutputStream output, String[] attributes, UWSSerializer serializer) throws UWSException, IOException, Exception {
        String errorMsgPart = null;
        errorMsgPart = attributes == null || attributes.length <= 0 ? "the job \"" + this.getJobId() + "\"" : "the given attribute \"" + attributes[0] + "\" of the job \"" + this.getJobId() + "\"";
        if (output == null) {
            throw new NullPointerException("Missing serialization output stream when serializing " + errorMsgPart + "!");
        }
        String serialization = this.serialize(attributes, serializer);
        if (serialization == null) {
            this.getLogger().logJob(UWSLog.LogLevel.ERROR, this, "SERIALIZE", "Error while serializing " + errorMsgPart + ": NULL was returned.", null);
            throw new UWSException(500, "Incorrect serialization value (=NULL) ! => impossible to serialize " + errorMsgPart + ".");
        }
        output.print(serialization);
        output.flush();
    }

    public String toString() {
        return "JOB {jobId: " + this.jobId + "; phase: " + this.phase + "; runId: " + this.getRunId() + "; ownerId: " + this.owner + "; executionDuration: " + this.getExecutionDuration() + "; destructionTime: " + this.getDestructionTime() + "; quote: " + this.quote + "; NbResults: " + this.results.size() + "; " + (this.errorSummary != null ? this.errorSummary.toString() : "No error") + " ; HasJobInfo: \"" + (this.jobInfo != null ? "yes" : "no") + "\"  }";
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object anotherJob) {
        if (anotherJob instanceof UWSJob) {
            return this.jobId.equals(((UWSJob)anotherJob).jobId);
        }
        return false;
    }

    protected final class JobTimeOut
    extends Thread {
        public JobTimeOut() {
            super(JobThread.tg, "TimeOut_" + UWSJob.this.jobId);
        }

        @Override
        public void run() {
            long maxDuration = UWSJob.this.getExecutionDuration();
            if (UWSJob.this.thread != null && UWSJob.this.thread.isAlive() && maxDuration != 0L && maxDuration > 0L) {
                try {
                    UWSJob.this.thread.join(maxDuration * 1000L);
                    if (!UWSJob.this.isFinished()) {
                        UWSJob.this.abort();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (UWSException ue) {
                    UWSJob.this.getLogger().logJob(UWSLog.LogLevel.WARNING, UWSJob.this, "EXECUTING", "Unexpected error while waiting the end of the execution of the job \"" + UWSJob.this.jobId + "\" (thread ID: " + UWSJob.this.thread.getId() + ")!", ue);
                }
            }
        }
    }
}

