/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import java.util.logging.Logger;
import vo.parameter.MultiValuedParamNotSupported;

class Parser {
    protected static final Logger LOGGER = Logger.getLogger("Parser");

    public static String getSingleValue(Map<String, String[]> params, String name) {
        return Parser.getSingleValue(params, name, null);
    }

    public static String getSingleValue(Map<String, String[]> params, String name, String defaultValue) {
        String[] valArr = params.get(name);
        if (valArr == null) {
            LOGGER.info("ParamDefault " + name + " : " + defaultValue);
            return defaultValue;
        }
        if (valArr.length == 0) {
            LOGGER.info("ParamDefault " + name + " : " + defaultValue);
            return defaultValue;
        }
        if (valArr.length == 1) {
            LOGGER.info("ParamFound   " + name + " : " + valArr[0]);
            return valArr[0];
        }
        throw new MultiValuedParamNotSupported(name + " was found " + valArr.length + " times");
    }

    public static double[] parseIntervalString(String value, String errorMsgPrefix) {
        double[] dblArr = new double[2];
        String[] arr = value.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException(errorMsgPrefix + " : no value, or value contains no space");
        }
        if (arr.length != 1 && arr.length != 2) {
            throw new IllegalArgumentException(errorMsgPrefix + " : must have normally two (or one re-used for both limits) space-delimited elements, but found " + arr.length + "  (value = " + value + ")");
        }
        dblArr[0] = Parser.parseDoubleInf(arr[0]);
        dblArr[1] = arr.length == 1 ? dblArr[0] : Parser.parseDoubleInf(arr[1]);
        return dblArr;
    }

    private static double parseDoubleInf(String str) {
        if ("Inf".equals(str) || "+Inf".equals(str)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-Inf".equals(str)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(str);
    }
}

