

import uk.ac.starlink.table.*;// ColumnInfo needed

class ObscoreExt
{
   public static final ColumnInfo[] OBSCORE_COLINFO =
   {
      new ColumnInfo( "dataproduct_type",  String.class,  "Dataproduct Type (image|cube)" ),
      new ColumnInfo( "calib_level",       Integer.class, "Calibration level" ),
      new ColumnInfo( "obs_collection",    String.class,  "Collection" ),
      new ColumnInfo( "obs_id",            String.class,  "Observation Id" ),
      new ColumnInfo( "obs_publisher_did", String.class,  "Publisher Did" ),

      new ColumnInfo( "access_url",     String.class, "Access URL" ),
      new ColumnInfo( "access_format",  String.class, "Format (MIME type)" ),
      new ColumnInfo( "access_estsize", Long.class,   "Extimated size (KB)" ),

      new ColumnInfo( "target_name", String.class,  "Target" ),

      new ColumnInfo( "s_ra",         Double.class, "Right Ascention" ),
      new ColumnInfo( "s_dec",        Double.class, "Declination" ),
      new ColumnInfo( "s_fov",        Double.class, "Field of view" ),
      new ColumnInfo( "s_region",     String.class, "Region" ),
      new ColumnInfo( "s_xel1",       Long.class,   "Pixels axis1" ),
      new ColumnInfo( "s_xel2",       Long.class,   "Pixels axis2" ),
      new ColumnInfo( "s_resolution", Double.class, "Spatial resolution" ),

      new ColumnInfo( "t_min",        Double.class, "Time min" ),
      new ColumnInfo( "t_max",        Double.class, "Time max" ),
      new ColumnInfo( "t_exptime",    Double.class, "Exposure time" ),
      new ColumnInfo( "t_resolution", Double.class, "Time resolution" ),
      new ColumnInfo( "t_xel",        Long.class,   "Time pixels" ),

      new ColumnInfo( "em_min",       Double.class, "Spectrum min" ),
      new ColumnInfo( "em_max",       Double.class, "Spectrum max" ),
      new ColumnInfo( "em_res_power", Double.class, "Spectrum resolution power" ),
      new ColumnInfo( "em_xel",       Long.class,   "Spectrum pixels" ),

      new ColumnInfo( "o_ucd", String.class, "Observable UCD" ),

      new ColumnInfo( "pol_states", String.class, "Polarization states" ),
      new ColumnInfo( "pol_xel",    Long.class,   "Polarization pixels" ),

      new ColumnInfo( "facility_name", String.class, "Facility" ),
      new ColumnInfo( "instrument_name", String.class, "Instrument" ),
   };

   public static Object[] obscoreRow( Dataset dataset )
   {
      return new Object[]
      {
         dataset.obsCore.dataproduct_type,//dataset.dataType, 
            Integer.valueOf( dataset.obsCore.calib_level ),
            dataset.obsCore.obs_collection,
            dataset.obsCore.obs_id,
            dataset.obsCore.obs_publisher_did,

            dataset.obsCore.access_url,//dataset.access.accessCutoutUrl,
            dataset.obsCore.access_format,
            Long.valueOf( dataset.obsCore.access_estsize ),

            dataset.obsCore.target_name,

            Double.valueOf(dataset.obsCore.s_ra),Double.valueOf(dataset.obsCore.s_dec),
            Double.valueOf(dataset.obsCore.s_fov),

            dataset.obsCore.s_region,
            Long.valueOf( dataset.obsCore.s_xel1 ), Long.valueOf( dataset.obsCore.s_xel2 ),
            Double.valueOf(dataset.obsCore.s_resolution),

            Double.valueOf(dataset.obsCore.t_min), Double.valueOf(dataset.obsCore.t_max),
            Double.valueOf(dataset.obsCore.t_exptime), Double.valueOf(dataset.obsCore.t_resolution),
            Long.valueOf( dataset.obsCore.t_xel ),

            Double.valueOf(dataset.obsCore.em_min), Double.valueOf(dataset.obsCore.em_max),
            Double.valueOf(dataset.obsCore.em_res_power),
            Long.valueOf( dataset.obsCore.em_xel ),

            dataset.obsCore.o_ucd,

            dataset.obsCore.pol_states,
            Long.valueOf( dataset.obsCore.pol_xel ),

            dataset.obsCore.facility_name,
            dataset.obsCore.instrument_name,
      };
   }



   public static final ColumnInfo[] VLKB_COLINFO =
   {
      new ColumnInfo( "overlap",     Integer.class, "Overlap Code" ),
      new ColumnInfo( "overlapSky",  Integer.class, "Overlap Code for Sky axes" ),
      new ColumnInfo( "overlapSpec", Integer.class, "Overlap Code for Spectral axis" ),

      new ColumnInfo( "P1lon", Double.class, "P1 longitude" ),
      new ColumnInfo( "P1lat", Double.class, "P1 latitude" ),
      new ColumnInfo( "P2lon", Double.class, "P2 longitude" ),
      new ColumnInfo( "P2lat", Double.class, "P2 latitude" ),
      new ColumnInfo( "P3lon", Double.class, "P3 longitude" ),
      new ColumnInfo( "P3lat", Double.class, "P3 latitude" ),
      new ColumnInfo( "P4lon", Double.class, "P4 longitude" ),
      new ColumnInfo( "P4lat", Double.class, "P4 latitude" ),

      new ColumnInfo( "file_url",   String.class, "Access URL: all file" ),
      new ColumnInfo( "cutout_url", String.class, "Access URL: cut file" ),
      new ColumnInfo( "merge_url",  String.class, "Access URL: demosaicing files" ),

   };

   public static Object[] vlkbRow( Dataset dataset )
   {
      return new Object[]
      {
         Integer.valueOf( dataset.overlapCode ),
            Integer.valueOf( dataset.overlapCodeSky ),
            Integer.valueOf( dataset.overlapCodeVel ),

            Double.valueOf(dataset.vertices_deg.lon[0]), Double.valueOf(dataset.vertices_deg.lat[0]),
            Double.valueOf(dataset.vertices_deg.lon[1]), Double.valueOf(dataset.vertices_deg.lat[1]),
            Double.valueOf(dataset.vertices_deg.lon[2]), Double.valueOf(dataset.vertices_deg.lat[2]),
            Double.valueOf(dataset.vertices_deg.lon[3]), Double.valueOf(dataset.vertices_deg.lat[3]),

            dataset.access.accessFileUrl,
            dataset.access.accessCutoutUrl,
            dataset.access.accessMosaicUrl,
      };
   }



   public static final ColumnInfo[] SUBSURVEY_COLINFO =
   {
      new ColumnInfo( "velocity_unit", String.class, "Velocity Unit" ),
      new ColumnInfo( "survey",        String.class, "Survey name" ),
      new ColumnInfo( "species",       String.class, "Species" ),
      new ColumnInfo( "transition",    String.class, "Transition" ),
      new ColumnInfo( "description",   String.class, "Descritpion" )
   };

   public static Object[] subsurveyRow( Subsurvey subsurvey )
   {
      return new Object[]
      {
         subsurvey.vel_unit,
            subsurvey.surveyname,
            subsurvey.species,
            subsurvey.transition,
            subsurvey.description
      };
   }



   public static final ColumnInfo[] OBSCORE_VLKB_COLINFO = concat(OBSCORE_COLINFO, VLKB_COLINFO);

   public static Object[] obscoreVlkbRow( Dataset dataset )
   {
      return concat(obscoreRow(dataset),vlkbRow(dataset));
   }


   public static final ColumnInfo[] OBSCORE_VLKB_SUBSURVEY_COLINFO = concat(concat(OBSCORE_COLINFO, VLKB_COLINFO), SUBSURVEY_COLINFO);

   public static Object[] obscoreVlkbSubsurveyRow( Dataset dataset, Subsurvey subsurvey )
   {
      return concat(concat(obscoreRow(dataset),vlkbRow(dataset)), subsurveyRow(subsurvey));
   }




   private static ColumnInfo[] concat(ColumnInfo[] arr1, ColumnInfo[] arr2)
   {
      ColumnInfo[] oc = new ColumnInfo[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };

   private static Object[] concat(Object[] arr1, Object[] arr2)
   {
      Object[] oc = new Object[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };
}

