
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


class SearchSettings
{
   public static SearchSettings getInstance(String settingsFileName)
   {
      try
      {
         InputStream ins = SearchSettings.class.getClassLoader().getResourceAsStream(settingsFileName);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            DbConnArgs dbConnArgs = loadDbConnArgs(properties);

            return new SearchSettings(dbConnArgs);
         }
         else
         {
            throw new IllegalStateException(settingsFileName + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + settingsFileName + " file", ex);
      }
   }

   private static DbConnArgs loadDbConnArgs(Properties properties)
   {
      DbConnArgs dbConnArgs = new DbConnArgs();
      dbConnArgs.uri       = properties.getProperty("db_uri","jdbc:postgresql://localhost:5432/vialactea").strip();
      dbConnArgs.user_name = properties.getProperty("db_user_name","").strip();
      dbConnArgs.password  = properties.getProperty("db_password","").strip();

      return dbConnArgs;
   }


   // instance; separate classes allow grouping of settings
   // DbConnArgs - db_*

   public DbConnArgs dbConnArgs;

   private SearchSettings(DbConnArgs dbConnArgs)
   {
      this.dbConnArgs = dbConnArgs;
   }

}

