
import java.util.logging.Logger;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.io.*;


import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;


import java.nio.charset.Charset;

import vo.parameter.*;
import vo.error.*;


public class FormatResponseFilter implements Filter
{
   private static final Logger LOGGER = Logger.getLogger(FormatResponseFilter.class.getName());
   private static final FormatResponseSettings settings = FormatResponseSettings.getInstance(
         "formatresponsefilter.properties");

   public void init(FilterConfig filterConfig) throws ServletException
   {
      LOGGER.config("Default charset: " + Charset.defaultCharset());
      LOGGER.config("cutout_url: " + settings.serviceUrls.cutoutUrl());
   }

   public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
      throws IOException, ServletException
   {
      LOGGER.fine("trace");
      LOGGER.fine("REQUEST START");

      final String RESPONSE_ENCODING   = "UTF-8";

      FormatResponseWrapper responseWrapper = new FormatResponseWrapper((HttpServletResponse) response);

      try
      {
         long startTime_msec = System.currentTimeMillis();

         chain.doFilter(request, responseWrapper);

         String[] pubdidArr = responseWrapper.getPubdidArr();

         if (pubdidArr != null)
         {
            PrintWriter responseWriter = ((HttpServletResponse)response).getWriter();

            Map<String, String[]> params = request.getParameterMap();
            Pos  pos  = Pos.parsePos(params);
            Band band = Band.parseBand(params);

            DbObstap.Obstap[] obstapArr = queryObstap(responseWrapper.getDbConnArgs(), pubdidArr, pos, band);

            LOGGER.info("collected metadata for " + obstapArr.length + " datasets");

            response.setCharacterEncoding(RESPONSE_ENCODING);
            response.setContentType("application/xml");
            boolean showDuration = true;

            XmlSerializer.serializeToVoTable(responseWriter, RESPONSE_ENCODING,
                  obstapArr,
                  settings.serviceUrls.cutoutUrl(),
                  showDuration,startTime_msec);

            responseWriter.close();
         }
         else
         {
            LOGGER.warning("SearchServlet returned null pubdidArr.");
         }
      }
      catch(MultiValuedParamNotSupported ex)
      {
         LOGGER.warning("MultiValuedParamNotSupported: " + ex.getMessage());

         responseWrapper.setStatus(HttpServletResponse.SC_BAD_REQUEST);
         responseWrapper.setContentType("text/plain");

         PrintWriter writer = responseWrapper.getWriter();
         Lib.doMultiValuedParamNotSupported(ex.getMessage(), writer);
         writer.close();
      }
      catch(IllegalArgumentException ex)
      {
         LOGGER.warning("IllegalArgumentException: " + ex.getMessage());

         responseWrapper.setStatus(HttpServletResponse.SC_BAD_REQUEST);
         responseWrapper.setContentType("text/plain");

         PrintWriter writer = responseWrapper.getWriter();
         Lib.doUsageError(ex.getMessage(), writer);
         writer.close();
      }
      catch(Exception ex)
      {
         LOGGER.warning("Exception: " + ex.getMessage());
         ex.printStackTrace();

         responseWrapper.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
         responseWrapper.setContentType("text/plain");

         PrintWriter writer = responseWrapper.getWriter();
         Lib.doError(ex.toString(), writer);
         writer.close();
      }

      LOGGER.fine("REQUEST END");
   }

   public void destroy()
   {
      LOGGER.fine("trace");
   }


   private DbObstap.Obstap[] queryObstap(DbConnArgs dbConnArgs, String[] pubdidArr, Pos pos, Band band)
         throws Exception
      {
         LOGGER.fine("trace " + dbConnArgs.toString());

         DbObstap dbObstap;
         synchronized(DbObstap.class)
         {
            dbObstap = new DbObstap(dbConnArgs);
         }

         return dbObstap.queryOutputData(pubdidArr, pos, band);
      }

}

