#!/bin/bash

set -eux

{
date
env

# set optional
CUTOUT_SERVICE_URL=${CUTOUT_SERVICE_URL:-""}
DISCOVERY_CONTEXT_ROOT=${DISCOVERY_CONTEXT_ROOT:-siav2}
DBG_LEVEL=${DEBUG_LEVEL:-CONFIG}


# configure CONTEXT_ROOT

mkdir -p $CATALINA_BASE/conf/Catalina/localhost
echo "<Context docBase=\"$WEBAPP_DIR\"/>" > $CATALINA_BASE/conf/Catalina/localhost/$DISCOVERY_CONTEXT_ROOT.xml


# configure DB with ObsTAP
{
   echo "db_uri=$DB_URI"
   echo "db_user_name=$DB_USERNAME"
   echo "db_password=$DB_PASSWORD"
} > $WEBAPP_DIR/WEB-INF/classes/search.properties


# configure response format
{
   echo "cutout_url=$CUTOUT_SERVICE_URL"
} > $WEBAPP_DIR/WEB-INF/classes/formatresponsefilter.properties

# configure debug level

sed -i "s/.*SearchServlet\.level.*=.*/SearchServlet.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/siav2.logging.properties
sed -i "s/.*FormatResponseFilter\.level.*=.*/FormatResponseFilter.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/siav2.logging.properties
sed -i "s/.*DbObstap\.level.*=.*/DbObstap.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/siav2.logging.properties


###################################################################
date

} 1> $STARTUP_LOG

exec $CATALINA_HOME/bin/catalina.sh run

