/*
 * Decompiled with CFR 0.152.
 */
package uws.service.file;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Scanner;
import java.util.regex.MatchResult;

public final class EventFrequency {
    private static final NumberFormat NN = new DecimalFormat("00");
    private static final DateFormat EVENT_ID_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmm");
    private static final String[] WEEK_DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] DAY_SUFFIX = new String[]{"st", "nd", "rd", "th"};
    private char dwm = (char)68;
    private int day = 0;
    private int hour = 0;
    private int min = 0;
    private String eventID = "";
    private long nextEvent = -1L;

    public EventFrequency(String interval) {
        int p = -1;
        if (interval == null) {
            interval = "";
        } else {
            interval = interval.replaceAll("[ \t]+", " ").trim();
            p = interval.indexOf(32);
        }
        if (p == 1 || interval.length() == 1) {
            Scanner scan = null;
            this.dwm = interval.charAt(0);
            String str = interval.substring(p + 1);
            scan = new Scanner(str);
            switch (this.dwm) {
                case 'D': {
                    scan.findInLine("(\\d{1,2}) (\\d{1,2})");
                    try {
                        MatchResult result = scan.match();
                        this.hour = this.parseHour(result.group(1));
                        this.min = this.parseMinute(result.group(2));
                    }
                    catch (IllegalStateException ise) {
                        this.min = 0;
                        this.hour = 0;
                        this.day = 0;
                    }
                    break;
                }
                case 'M': 
                case 'W': {
                    scan.findInLine("(\\d{1,2}) (\\d{1,2}) (\\d{1,2})");
                    try {
                        MatchResult result = scan.match();
                        this.day = this.dwm == 'W' ? this.parseDayOfWeek(result.group(1)) : this.parseDayOfMonth(result.group(1));
                        this.hour = this.parseHour(result.group(2));
                        this.min = this.parseMinute(result.group(3));
                    }
                    catch (IllegalStateException ise) {
                        this.day = this.dwm == 'W' ? 0 : 1;
                        this.min = 0;
                        this.hour = 0;
                    }
                    break;
                }
                case 'h': {
                    scan.findInLine("(\\d{1,2})");
                    try {
                        MatchResult result = scan.match();
                        this.min = this.parseMinute(result.group(1));
                    }
                    catch (IllegalStateException ise) {
                        this.min = 0;
                    }
                    break;
                }
                case 'm': {
                    break;
                }
                default: {
                    this.dwm = (char)68;
                    this.min = 0;
                    this.hour = 0;
                    this.day = 0;
                }
            }
            if (scan != null) {
                scan.close();
            }
        }
    }

    private int parseDayOfWeek(String dayNbStr) throws IllegalStateException {
        try {
            int d = Integer.parseInt(dayNbStr);
            if (d >= 1 && d <= WEEK_DAYS.length) {
                return d - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Incorrect day of week (" + dayNbStr + ") ; it should be between 1 and 7 (both included)!");
    }

    private int parseDayOfMonth(String dayStr) throws IllegalStateException {
        try {
            int d = Integer.parseInt(dayStr);
            if (d >= 1 && d <= 31) {
                return d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Incorrect day of month (" + dayStr + ") ; it should be between 1 and 31 (both included)!");
    }

    private int parseHour(String hourStr) throws IllegalStateException {
        try {
            int h = Integer.parseInt(hourStr);
            if (h >= 0 && h <= 23) {
                return h;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Incorrect hour number(" + hourStr + ") ; it should be between 0 and 23 (both included)!");
    }

    private int parseMinute(String minStr) throws IllegalStateException {
        try {
            int m = Integer.parseInt(minStr);
            if (m >= 0 && m <= 59) {
                return m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Incorrect minute number (" + minStr + ") ; it should be between 0 and 59 (both included)!");
    }

    public boolean isTimeElapsed() {
        return this.nextEvent <= 0L || System.currentTimeMillis() >= this.nextEvent;
    }

    public Date getNextEvent() {
        return this.nextEvent <= 0L ? null : new Date(this.nextEvent);
    }

    public String getEventID() {
        return this.eventID;
    }

    public Date nextEvent() {
        return this.nextEvent(new Date());
    }

    public Date nextEvent(Date lastEventDate) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(lastEventDate);
        switch (this.dwm) {
            case 'D': {
                date.add(6, 1);
                date.set(11, this.hour);
                date.set(12, this.min);
                date.set(13, 0);
                break;
            }
            case 'W': {
                int weekday = date.get(7) - 1;
                if (weekday == this.day) {
                    date.add(3, 1);
                } else {
                    int delta = this.day - weekday;
                    if (delta <= 0) {
                        delta += 7;
                    }
                    date.add(6, delta);
                }
                date.set(11, this.hour);
                date.set(12, this.min);
                date.set(13, 0);
                break;
            }
            case 'M': {
                date.add(2, 1);
                date.set(5, this.day);
                date.set(11, this.hour);
                date.set(12, this.min);
                date.set(13, 0);
                break;
            }
            case 'h': {
                date.add(11, 1);
                date.set(12, this.min);
                date.set(13, 0);
                break;
            }
            case 'm': {
                date.add(12, 1);
                date.set(13, 0);
            }
        }
        this.nextEvent = date.getTimeInMillis();
        this.eventID = EVENT_ID_FORMAT.format(new Date());
        return date.getTime();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        switch (this.dwm) {
            case 'D': {
                str.append("daily");
                str.append(" at ").append(NN.format(this.hour)).append(':').append(NN.format(this.min));
                break;
            }
            case 'W': {
                str.append("weekly on ").append(WEEK_DAYS[this.day % 6]);
                str.append(" at ").append(NN.format(this.hour)).append(':').append(NN.format(this.min));
                break;
            }
            case 'M': {
                str.append("monthly on the ").append(this.day).append(DAY_SUFFIX[Math.min(this.day - 1, 3)]);
                str.append(" at ").append(NN.format(this.hour)).append(':').append(NN.format(this.min));
                break;
            }
            case 'h': {
                str.append("hourly at ").append(NN.format(this.min));
                break;
            }
            case 'm': {
                str.append("every minute");
            }
        }
        return str.toString();
    }
}

