/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.nio.Buffer;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.util.ArrayFuncs;

public class CompressedImageData
extends BinaryTable {
    private TiledImageCompressionOperation tiledImageOperation;

    public CompressedImageData() {
    }

    public CompressedImageData(Header hdr) throws FitsException {
        super(hdr);
    }

    public void compress(CompressedImageHDU hdu) throws FitsException {
        this.tiledImageOperation().compress(hdu);
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        super.fillHeader(h);
        h.addValue((IFitsHeader)Compression.ZIMAGE, true);
    }

    public <T extends ICompressOption> T getCompressOption(Class<T> clazz) {
        return (T)((ICompressOption)this.tiledImageOperation().compressOptions().unwrap(clazz));
    }

    protected void forceNoLoss(int x, int y, int width, int heigth) {
        this.tiledImageOperation.forceNoLoss(x, y, width, heigth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getUncompressedData(Header hdr) throws FitsException {
        try {
            this.tiledImageOperation = new TiledImageCompressionOperation(this).read(hdr);
            Buffer buffer = this.tiledImageOperation.decompress();
            return buffer;
        }
        finally {
            this.tiledImageOperation = null;
        }
    }

    public void prepareUncompressedData(Object data, Header header) throws FitsException {
        this.tiledImageOperation().readPrimaryHeaders(header);
        if (data instanceof Buffer) {
            this.tiledImageOperation().prepareUncompressedData((Buffer)data);
        } else {
            Buffer source = this.tiledImageOperation().getBaseType().newBuffer(this.tiledImageOperation.getBufferSize());
            ArrayFuncs.copyInto(data, source.array());
            this.tiledImageOperation().prepareUncompressedData(source);
        }
    }

    private TiledImageCompressionOperation tiledImageOperation() {
        if (this.tiledImageOperation == null) {
            this.tiledImageOperation = new TiledImageCompressionOperation(this);
        }
        return this.tiledImageOperation;
    }

    protected void setCompressAlgorithm(HeaderCard compressAlgorithmCard) {
        this.tiledImageOperation().setCompressAlgorithm(compressAlgorithmCard);
    }

    protected void setQuantAlgorithm(HeaderCard quantAlgorithmCard) throws FitsException {
        this.tiledImageOperation().setQuantAlgorithm(quantAlgorithmCard);
    }

    protected CompressedImageData setTileSize(int ... axes) {
        this.tiledImageOperation().setTileAxes(axes);
        return this;
    }
}

