/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.LoginUriHelper;
import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.client.QueryStringBuilder;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.client.call.TokenResponse;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginFilter
implements Filter {
    private static final String OAUTH2_STATE = "oauth2_state";
    private static final String USER_DATA = "user_data";
    private ServiceLocator locator;
    private AuthConfig config;
    private RapClient rapClient;

    public void init(FilterConfig fc) throws ServletException {
        this.locator = ServiceLocator.getInstance();
        this.config = this.locator.getConfig();
        this.rapClient = this.locator.getRapClient();
        AuthConfig.checkLoginConfiguration(this.config);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute(USER_DATA) != null) {
            fc.doFilter(req, res);
            return;
        }
        if (this.isAuthorizationRedirectPhase(request)) {
            this.sendAuthorizationRedirect(request, response);
        } else {
            this.completeOidcLogin(request, response, fc);
        }
    }

    private boolean isAuthorizationRedirectPhase(HttpServletRequest request) {
        if (this.config.storeStateOnLoginEndpoint()) {
            return request.getParameter("state") == null;
        }
        boolean isLoginUri = request.getRequestURI().equals(request.getContextPath() + this.config.getLoginEndpoint());
        return !isLoginUri;
    }

    private void completeOidcLogin(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.validateState(request);
        String code = request.getParameter("code");
        String redirectUri = LoginUriHelper.getLoginUri(request, this.config);
        TokenResponse tokenResponse = this.rapClient.getTokenFromCode(code, redirectUri, (Object)request);
        User user = this.locator.getUserManager().getUserFromTokenResponse(tokenResponse);
        HttpSession session = request.getSession();
        session.setAttribute(USER_DATA, (Object)user);
        response.sendRedirect(LoginUriHelper.getBaseUrl(request));
    }

    private void validateState(HttpServletRequest request) {
        String state = request.getParameter("state");
        if (state == null) {
            throw new IllegalStateException("Missing state parameter");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Session not found. Unable to retrieve state.");
        }
        String savedState = (String)session.getAttribute(OAUTH2_STATE);
        if (savedState == null) {
            throw new IllegalStateException("No saved state found");
        }
        if (!state.equals(savedState)) {
            throw new IllegalStateException("State parameter doesn't match with saved state");
        }
    }

    private void sendAuthorizationRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String state = UUID.randomUUID().toString().replace("-", "").substring(0, 5);
        request.getSession(true).setAttribute(OAUTH2_STATE, (Object)state);
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder().param("client_id", this.rapClient.getClientId()).param("redirect_uri", LoginUriHelper.getLoginUri(request, this.config)).param("response_type", "code").param("scope", this.config.getScope()).param("state", state);
        String redirectParameters = queryStringBuilder.getQueryString();
        Object redirect = this.rapClient.getAuthorizationUri((Object)request).toString();
        redirect = (String)redirect + (((String)redirect).contains("?") ? "&" : "?");
        redirect = (String)redirect + redirectParameters;
        response.sendRedirect((String)redirect);
    }
}

