/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import it.inaf.ia2.aa.AuthConfig;
import javax.servlet.http.HttpServletRequest;

public class LoginUriHelper {
    private LoginUriHelper() {
    }

    public static String getLoginUri(HttpServletRequest request, AuthConfig config) {
        String baseUrl = LoginUriHelper.getBaseUrl(request);
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 2);
        }
        return baseUrl + config.getLoginEndpoint();
    }

    public static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String forwardedProto = request.getHeader("X-Forwarded-Proto");
        if (forwardedProto != null) {
            scheme = forwardedProto;
        }
        int port = request.getServerPort();
        String forwaredPort = request.getHeader("X-Forwarded-Port");
        if (forwaredPort != null) {
            port = request.getIntHeader("X-Forwarded-Port");
        }
        boolean addPort = "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443;
        String url = scheme + "://" + request.getServerName();
        if (addPort) {
            url = url + ":" + port;
        }
        url = url + request.getContextPath();
        return url;
    }
}

