/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSUrl;

public final class Json4Uws {
    private Json4Uws() {
    }

    public static final JSONObject getJson(UWS uws) throws JSONException {
        JSONObject json = new JSONObject();
        if (uws != null) {
            json.put("name", uws.getName());
            json.put("version", "1.1");
            json.put("description", uws.getDescription());
            JSONArray jobLists = new JSONArray();
            for (JobList jobList : uws) {
                JSONObject jsonJL = new JSONObject();
                UWSUrl jlUrl = jobList.getUrl();
                jsonJL.put("name", jobList.getName());
                if (jlUrl != null) {
                    jsonJL.put("href", jlUrl.getRequestURI());
                }
                jobLists.put(jsonJL);
            }
            json.put("jobLists", jobLists);
        }
        return json;
    }

    public static final JSONObject getJson(JobList jobsList, JobOwner owner) throws JSONException {
        return Json4Uws.getJson(jobsList, owner, null);
    }

    public static final JSONObject getJson(JobList jobsList, JobOwner owner, JobListRefiner listRefiner) throws JSONException {
        JSONObject json = new JSONObject();
        if (jobsList != null) {
            json.put("name", jobsList.getName());
            json.put("version", "1.1");
            JSONArray jsonJobs = new JSONArray();
            UWSUrl jobsListUrl = jobsList.getUrl();
            Iterator<UWSJob> it = jobsList.getJobs(owner);
            if (listRefiner != null) {
                it = listRefiner.refine(it);
            }
            JSONObject jsonObj = null;
            while (it.hasNext()) {
                jsonObj = Json4Uws.getJson(it.next(), jobsListUrl, true);
                if (jsonObj == null) continue;
                jsonJobs.put(jsonObj);
            }
            json.put("jobs", jsonJobs);
        }
        return json;
    }

    public static final JSONObject getJson(UWSJob job) throws JSONException {
        return Json4Uws.getJson(job, null, false);
    }

    public static final JSONObject getJson(UWSJob job, UWSUrl jobsListUrl, boolean reference) throws JSONException {
        JSONObject json = new JSONObject();
        if (job != null) {
            json.put("version", "1.1");
            json.put("jobId", job.getJobId());
            json.put("phase", (Object)job.getPhase());
            json.put("runId", job.getRunId());
            if (job.getOwner() != null) {
                json.put("owner", job.getOwner().getPseudo());
            }
            json.put("creationTime", ISO8601Format.format(job.getCreationTime()));
            if (reference) {
                if (jobsListUrl != null) {
                    jobsListUrl.setJobId(job.getJobId());
                    json.put("href", jobsListUrl.getRequestURL());
                }
            } else {
                if (job.getStartTime() != null) {
                    if (job.getQuote() > 0L) {
                        long quoteTime = job.getStartTime().getTime() + 1000L * job.getQuote();
                        json.put("quote", ISO8601Format.format(quoteTime));
                    }
                    json.put("startTime", ISO8601Format.format(job.getStartTime()));
                }
                if (job.getEndTime() != null) {
                    json.put("endTime", ISO8601Format.format(job.getEndTime()));
                }
                if (job.getDestructionTime() != null) {
                    json.put("destruction", ISO8601Format.format(job.getDestructionTime()));
                }
                json.put("executionDuration", job.getExecutionDuration());
                json.put("parameters", Json4Uws.getJobParamsJson(job));
                json.put("results", Json4Uws.getJobResultsJson(job));
                json.put("error", Json4Uws.getJson(job.getErrorSummary()));
                if (job.getJobInfo() != null) {
                    json.put("jobInfo", Json4Uws.getJobInfoJson(job));
                }
            }
        }
        return json;
    }

    public static final JSONObject getJobInfoJson(UWSJob job) throws JSONException {
        if (job.getJobInfo() != null) {
            try {
                return XML.toJSONObject(job.getJobInfo().getXML(null));
            }
            catch (UWSException ue) {
                throw new JSONException(ue);
            }
        }
        return null;
    }

    public static final JSONObject getJobParamsJson(UWSJob job) throws JSONException {
        JSONObject json = new JSONObject();
        if (job != null) {
            for (String name : job.getAdditionalParameters()) {
                Object val = job.getAdditionalParameterValue(name);
                if (val != null && val.getClass().isArray()) {
                    JSONArray array = new JSONArray();
                    for (Object o : (Object[])val) {
                        if (o == null) continue;
                        array.put(o.toString());
                    }
                    json.put(name, array);
                    continue;
                }
                json.put(name, val);
            }
        }
        return json;
    }

    public static final JSONArray getJobResultsJson(UWSJob job) throws JSONException {
        JSONArray json = new JSONArray();
        if (job != null) {
            Iterator<Result> it = job.getResults();
            if (it == null) {
                return null;
            }
            while (it.hasNext()) {
                json.put(Json4Uws.getJobResultJson(it.next()));
            }
        }
        return json;
    }

    public static final JSONObject getJobResultJson(Result r) throws JSONException {
        JSONObject resultJson = new JSONObject();
        if (r != null) {
            resultJson.put("id", r.getId());
            resultJson.put("type", r.getType());
            resultJson.put("href", r.getHref());
            if (r.getMimeType() != null) {
                resultJson.put("mime-type", r.getMimeType());
            }
            if (r.getSize() >= 0L) {
                resultJson.put("size", r.getSize());
            }
            resultJson.put("redirection", r.isRedirectionRequired());
        }
        return resultJson;
    }

    public static final JSONObject getJson(ErrorSummary error) throws JSONException {
        JSONObject errorJson = new JSONObject();
        if (error != null) {
            errorJson.put("type", (Object)error.getType());
            errorJson.put("hasDetail", error.hasDetail());
            errorJson.put("detailsRef", error.getDetails());
            errorJson.put("message", error.getMessage());
        }
        return errorJson;
    }

    public static final JSONObject getJson(String key, long value) throws JSONException {
        JSONObject json = new JSONObject();
        if (key != null && !key.trim().isEmpty()) {
            json.put(key, value);
        }
        return json;
    }

    public static final JSONObject getJson(String key, String value) throws JSONException {
        JSONObject json = new JSONObject();
        if (key != null && !key.trim().isEmpty()) {
            json.put(key, value);
        }
        return json;
    }
}

