/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import uws.UWSException;
import uws.job.UWSJob;
import uws.job.manager.AbstractQueuedExecutionManager;
import uws.service.log.UWSLog;

public class QueuedExecutionManager
extends AbstractQueuedExecutionManager {
    protected int nbMaxRunningJobs = Integer.MAX_VALUE;
    public static final int NO_QUEUE = Integer.MAX_VALUE;

    public QueuedExecutionManager(UWSLog logger) {
        super(logger);
    }

    public QueuedExecutionManager(UWSLog logger, int maxRunningJobs) {
        this(logger);
        this.nbMaxRunningJobs = maxRunningJobs <= 0 ? Integer.MAX_VALUE : maxRunningJobs;
    }

    public final void setNoQueue() {
        this.nbMaxRunningJobs = Integer.MAX_VALUE;
        this.refresh();
    }

    public final int getMaxRunningJobs() {
        return this.nbMaxRunningJobs;
    }

    public void setMaxRunningJobs(int maxRunningJobs) throws UWSException {
        this.nbMaxRunningJobs = maxRunningJobs <= 0 ? Integer.MAX_VALUE : maxRunningJobs;
        this.refresh();
    }

    @Override
    public final boolean isReadyForExecution(UWSJob jobToExecute) {
        if (!this.hasQueue()) {
            return true;
        }
        return this.runningJobs.size() < this.nbMaxRunningJobs;
    }
}

