/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer.filter;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.serializer.filter.AfterFilter;
import uws.job.serializer.filter.JobFilter;
import uws.job.serializer.filter.NoArchivedFilter;
import uws.job.serializer.filter.PhasesFilter;

public class JobListRefiner {
    protected final List<JobFilter> filters = new ArrayList<JobFilter>();
    protected List<UWSJob> jobList = new ArrayList<UWSJob>();
    protected Comparator<UWSJob> sortComp = null;
    protected int topSize = -1;
    protected boolean reverseOrder = false;

    protected JobListRefiner() {
    }

    public JobListRefiner(HttpServletRequest request) throws UWSException {
        ExecutionPhase phase = null;
        Date afterDate = null;
        int last = -1;
        AfterFilter afterFilter = null;
        PhasesFilter phasesFilter = null;
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String pName = (String)paramNames.nextElement();
            String[] values = request.getParameterValues(pName);
            if (pName.toUpperCase().equals("PHASE")) {
                for (String p : values) {
                    if (p == null) continue;
                    try {
                        phase = ExecutionPhase.valueOf(p.toUpperCase());
                        if (phasesFilter == null) {
                            phasesFilter = new PhasesFilter(phase);
                            continue;
                        }
                        phasesFilter.add(phase);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new UWSException(400, "Incorrect PHASE value: \"" + p + "\"! No such execution phase is known by this service.");
                    }
                }
                continue;
            }
            if (pName.toUpperCase().equals("AFTER")) {
                for (String p : values) {
                    if (p == null) continue;
                    try {
                        afterDate = ISO8601Format.parseToDate(p);
                        if (afterFilter != null && !afterDate.after(afterFilter.getDate())) continue;
                        afterFilter = new AfterFilter(afterDate);
                    }
                    catch (ParseException pe) {
                        throw new UWSException(400, "Incorrect AFTER value: \"" + p + "\"! The date must be formatted in ISO-8601.");
                    }
                }
                continue;
            }
            if (!pName.toUpperCase().equals("LAST")) continue;
            for (String p : values) {
                if (p == null) continue;
                try {
                    last = Integer.parseInt(p);
                    if (last >= 0 && (this.topSize < 0 || last < this.topSize)) {
                        this.topSize = last;
                        continue;
                    }
                    if (last >= 0) continue;
                    throw new UWSException(400, "Incorrect LAST value: \"" + p + "\"! A positive integer was expected.");
                }
                catch (NumberFormatException nfe) {
                    throw new UWSException(400, "Incorrect LAST value: \"" + p + "\"! A positive integer was expected.");
                }
            }
        }
        if (phasesFilter != null) {
            this.filters.add(phasesFilter);
        } else {
            this.filters.add(new NoArchivedFilter());
        }
        if (afterFilter != null) {
            this.filters.add(afterFilter);
        }
        if (this.topSize >= 0) {
            this.sortComp = new JobComparator();
            this.reverseOrder = false;
        }
    }

    protected final void addJob(UWSJob job) {
        if (job == null) {
            return;
        }
        if (this.sortComp == null) {
            this.jobList.add(job);
        } else {
            int index = Collections.binarySearch(this.jobList, job, this.sortComp);
            if (index < 0) {
                index = -(index + 1);
            }
            this.jobList.add(index, job);
        }
    }

    public Iterator<UWSJob> refine(Iterator<UWSJob> jobList) {
        if (this.jobList instanceof AbstractList) {
            ((AbstractList)this.jobList).clear();
        } else {
            while (!this.jobList.isEmpty()) {
                this.jobList.remove(0);
            }
        }
        while (jobList.hasNext()) {
            UWSJob job = jobList.next();
            if (!this.match(job)) continue;
            this.addJob(job);
        }
        if (this.topSize < 0) {
            return this.jobList.iterator();
        }
        return new TopIterator(this.jobList, this.topSize, this.reverseOrder);
    }

    protected final boolean match(UWSJob job) {
        if (job == null) {
            return false;
        }
        for (JobFilter filter : this.filters) {
            if (filter.match(job)) continue;
            return false;
        }
        return true;
    }

    protected static final class TopIterator
    implements Iterator<UWSJob> {
        private final List<UWSJob> list;
        private final int topSize;
        private final boolean reverseOrder;
        private int currentIndex = -1;
        private int count = 0;

        public TopIterator(List<UWSJob> joblist, int topSize, boolean reverse) {
            this.list = joblist;
            this.topSize = topSize;
            this.reverseOrder = reverse;
            this.currentIndex = this.reverseOrder && topSize >= 0 ? (this.list.size() <= topSize ? this.list.size() : topSize) : (this.reverseOrder ? this.list.size() : -1);
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return (this.topSize < 0 || this.count + 1 <= this.topSize) && (this.reverseOrder ? this.currentIndex - 1 >= 0 : this.currentIndex + 1 < this.list.size());
        }

        @Override
        public UWSJob next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more jobs in this filtered job list!");
            }
            ++this.count;
            this.currentIndex = this.reverseOrder ? this.currentIndex - 1 : this.currentIndex + 1;
            return this.list.get(this.currentIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("No remove operation possible on this iterator of filtered job list!");
        }
    }

    public static final class JobComparator
    implements Comparator<UWSJob> {
        @Override
        public int compare(UWSJob o1, UWSJob o2) {
            return -o1.getCreationTime().compareTo(o2.getCreationTime());
        }
    }
}

