/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.parameters.UWSParameters;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class SetUWSParameter
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public SetUWSParameter(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Set UWS Parameter";
    }

    @Override
    public String getDescription() {
        return "Let change one of the standard UWS parameters of a job (e.g. phase, executionduration, destruction) (URL: {baseUWS_URL}/{jobListName}/{jobId}/{uws-param}, where {uws-param} = \"phase\" or \"executionduration\" or \"destruction\", Method: HTTP-POST or HTTP-PUT, Parameter: \"{uws-param}={param-value}\" in POST and \"{param-value\" in PUT (content-type:text/plain))";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && urlInterpreter.getAttributes().length == 1 && urlInterpreter.getAttributes()[0].toLowerCase().matches(UWSParameters.UWS_RW_PARAMETERS_REGEXP) && (request.getMethod().equalsIgnoreCase("post") || request.getMethod().equalsIgnoreCase("put")) && UWSToolBox.hasParameter(urlInterpreter.getAttributes()[0], request, false);
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        UWSJob job = this.getJob(urlInterpreter);
        if (user != null && !user.hasWritePermission(job)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, job.getJobId()));
        }
        String name = urlInterpreter.getAttributes()[0];
        job.addOrUpdateParameter(name, UWSToolBox.getParameter(name, request, false), user);
        this.uws.redirect(urlInterpreter.jobSummary(urlInterpreter.getJobListName(), job.getJobId()).getRequestURL(), request, user, this.getName(), response);
        return true;
    }
}

