/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.service.file.UWSFileManager;
import uws.service.request.RequestParser;
import uws.service.request.UploadFile;

public class NoEncodingParser
implements RequestParser {
    public static final int DEFAULT_SIZE_LIMIT = 0x200000;
    public static int SIZE_LIMIT = 0x200000;
    protected final UWSFileManager fileManager;

    public NoEncodingParser(UWSFileManager fileManager) {
        if (fileManager == null) {
            throw new NullPointerException("Missing file manager => can not create a SingleDataParser!");
        }
        this.fileManager = fileManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> parse(HttpServletRequest request) throws UWSException {
        Object reqID;
        String paramName;
        if (request.getContentLength() <= 0) {
            return new HashMap<String, Object>();
        }
        if (request.getContentLength() > (SIZE_LIMIT < 0 ? 0x200000 : SIZE_LIMIT)) {
            throw new UWSException("JDL too big (>" + SIZE_LIMIT + " bytes) => Request rejected! You should see with the service administrator to extend this limit.");
        }
        if (request.getMethod() != null && request.getMethod().equalsIgnoreCase("put")) {
            paramName = request.getRequestURI();
            if (paramName.lastIndexOf(47) + 1 > 0) {
                paramName = paramName.substring(paramName.lastIndexOf(47) + 1);
            }
        } else {
            paramName = "JDL";
        }
        if ((reqID = request.getAttribute("UWS_REQUEST_ID")) == null || !(reqID instanceof String)) {
            reqID = new Date().getTime();
        }
        File f = new File(this.fileManager.getTmpDirectory(), "REQUESTBODY_" + reqID);
        BufferedOutputStream output = null;
        InputStream input = null;
        long totalLength = 0L;
        try {
            output = new BufferedOutputStream(new FileOutputStream(f));
            input = new BufferedInputStream((InputStream)request.getInputStream());
            byte[] buffer = new byte[2049];
            int len = input.read(buffer);
            if (len <= 0) {
                ((OutputStream)output).close();
                f.delete();
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put(paramName, "");
                HashMap<String, Object> hashMap = params;
                return hashMap;
            }
            if (len <= 2048 && request.getMethod() != null && request.getMethod().equalsIgnoreCase("put") && request.getContentType() != null && request.getContentType().toLowerCase().startsWith("text/plain")) {
                ((OutputStream)output).close();
                f.delete();
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put(paramName, new String(buffer, 0, len));
                HashMap<String, Object> hashMap = params;
                return hashMap;
            }
            do {
                ((OutputStream)output).write(buffer, 0, len);
                totalLength += (long)len;
            } while ((len = input.read(buffer)) > 0);
            ((OutputStream)output).flush();
        }
        catch (IOException ioe) {
            throw new UWSException(500, (Throwable)ioe, "Internal error => Impossible to get the JDL from the HTTP request!");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {}
            }
        }
        UploadFile lob = new UploadFile(paramName, f.toURI().toString(), this.fileManager);
        lob.mimeType = request.getContentType();
        lob.length = totalLength;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(paramName, lob);
        return parameters;
    }
}

