#!/bin/bash

set +e
LOG_FILE=/tmp/entrypoint.log

{
date
whoami
env
#########################################################################
#INST_DIR="/usr/local"
WEBAPP_DIR=/webapps

echo "SECURITY   : "$SECURITY
echo "DISCOVERY_CONTEXT_ROOT : "$DISCOVERY_CONTEXT_ROOT
echo "DISCOVERY_DB_URI       : "$DISCOVERY_DB_URI
echo "RESPONSE_FORMAT        : "$RESPONSE_FORMAT
echo "URL_CUTOUTS            : "$URL_CUTOUTS
echo "INST_DIR   : "$INST_DIR
echo "WEBAPP_DIR : "$WEBAPP_DIR
#########################################################################


if test -n "$DISCOVERY_CONTEXT_ROOT" && test -n "$DISCOVERY_DB_URI"
then

   if test -n "$SECURITY"
   then
     cd $WEBAPP_DIR/vlkb-search/WEB-INF/ && rm -f web.xml && cp web-search-$SECURITY.xml web.xml && cd -
   fi

   echo "<Context docBase=\"$WEBAPP_DIR/vlkb-search\"/>" > /var/lib/tomcat9/conf/Catalina/localhost/$DISCOVERY_CONTEXT_ROOT.xml
   echo "db_uri=$DISCOVERY_DB_URI"  >  $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_schema=datasets"        >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_user_name=$DB_USERNAME" >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_password=$DB_PASSWORD"  >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   # use the same DB for authz permissions (ObsCore with extensions)
   cp $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties $WEBAPP_DIR/vlkb-search/WEB-INF/classes/authpolicy.properties

   if test -n "$RESPONSE_FORMAT"
   then
      echo "response_format=$RESPONSE_FORMAT" >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/formatresponsefilter.properties
   fi


fi


# configure port/SSL connector: (path is relative to the dir where compose.yaml is
# - web.xml to run filters set above
# * ssl: set tomcat connector with certificates (ia2 needs SECTIGO, iam needs self-signed keystore.jks)
# * keep right jjwt*.jar libs (ia2 authlib needs v0.11, iam needs v0.12)
# assume all files in ssl sub-dir relative to where compose.yaml is
# set volume mapping in compose.yaml: ssl/ -> /etc/pki/tls/
case $SECURITY in
   ia2token)
      cp /root/ssl/server-connector-8443.xml /etc/tomcat9/server-connector-8443.xml
      rm /webapps/vlkb-search/WEB-INF/lib/jjwt-*0.12*.jar
      ;;
   iamtoken)
      cp /root/ssl/server-connector-8443.xml  /etc/tomcat9/server-connector-8443.xml
      rm /webapps/vlkb-search/WEB-INF/lib/jjwt-*0.11*.jar
      ;;
   *)
      echo "Security not configured, runs open."
      ;;
esac



if test -n "$SECURITY"
then
   cd /etc/tomcat9/ && ln -s server-connector-8443.xml server-connector.xml && cd -
else
   cd /etc/tomcat9/ && ln -s server-connector-8080.xml server-connector.xml && cd -
fi



# configure access-token validation
if test -f /srv/surveys/iamtoken.properties
then
   cp /srv/surveys/iamtoken.properties $WEBAPP_DIR/vlkb-search/WEB-INF/classes/
fi



date

} 1> $LOG_FILE 2>&1

JAVA_HOME=/usr/lib/jvm/java-17-openjdk-amd64 CATALINA_BASE=/var/lib/tomcat9 CATALINA_HOME=/usr/share/tomcat9 CATALINA_TMPDIR=/tmp /usr/libexec/tomcat9/tomcat-start.sh &

wait -n

